/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.container.impl.plugin.BpmPlatformPlugin;
import io.openbpm.bpm.engine.impl.variable.serializer.DefaultVariableSerializers;
import io.openbpm.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializers;
import io.openbpm.spin.DataFormats;
import io.openbpm.spin.plugin.impl.SpinPluginLogger;
import io.openbpm.spin.plugin.impl.SpinVariableSerializers;
import java.util.List;

public class SpinBpmPlatformPlugin
implements BpmPlatformPlugin {
    private static final SpinPluginLogger LOG = SpinPluginLogger.LOGGER;

    public void postProcessApplicationDeploy(ProcessApplicationInterface processApplication) {
        ProcessApplicationInterface rawPa = processApplication.getRawObject();
        if (rawPa instanceof AbstractProcessApplication) {
            AbstractProcessApplication application = (AbstractProcessApplication)rawPa;
            this.initializeVariableSerializers(application);
        } else {
            LOG.logNoDataFormatsInitiailized("process application data formats", "process application is not a sub class of " + AbstractProcessApplication.class.getName());
        }
    }

    protected void initializeVariableSerializers(AbstractProcessApplication abstractProcessApplication) {
        VariableSerializers paVariableSerializers = abstractProcessApplication.getVariableSerializers();
        if (paVariableSerializers == null) {
            paVariableSerializers = new DefaultVariableSerializers();
            abstractProcessApplication.setVariableSerializers(paVariableSerializers);
        }
        for (TypedValueSerializer<?> serializer : this.lookupSpinSerializers(abstractProcessApplication.getProcessApplicationClassloader())) {
            paVariableSerializers.addSerializer(serializer);
        }
    }

    protected List<TypedValueSerializer<?>> lookupSpinSerializers(ClassLoader classLoader) {
        DataFormats paDataFormats = new DataFormats();
        paDataFormats.registerDataFormats(classLoader);
        return SpinVariableSerializers.createObjectValueSerializers(paDataFormats);
    }

    public void postProcessApplicationUndeploy(ProcessApplicationInterface processApplication) {
    }
}

