/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import io.openbpm.bpm.engine.variable.value.ObjectValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import io.openbpm.spin.plugin.impl.FallbackSpinObjectValueSerializer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpinFallbackSerializerFactory
implements VariableSerializerFactory {
    public static final Pattern SPIN_SERIALIZER_NAME_PATTERN = Pattern.compile("spin://(.*)");

    public TypedValueSerializer<?> getSerializer(String serializerName) {
        Matcher matcher = SPIN_SERIALIZER_NAME_PATTERN.matcher(serializerName);
        if (matcher.matches()) {
            String serializationFormat = matcher.group(1);
            return new FallbackSpinObjectValueSerializer(serializationFormat);
        }
        return null;
    }

    public TypedValueSerializer<?> getSerializer(TypedValue value) {
        ObjectValue objectValue;
        if (value instanceof ObjectValue && (objectValue = (ObjectValue)value).getSerializationDataFormat() != null && !objectValue.isDeserialized()) {
            return new FallbackSpinObjectValueSerializer(objectValue.getSerializationDataFormat());
        }
        return null;
    }
}

