/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.util.ClassLoaderUtil;
import io.openbpm.bpm.engine.impl.util.ReflectUtil;
import io.openbpm.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializers;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.type.ValueTypeResolver;
import io.openbpm.spin.DataFormats;
import io.openbpm.spin.Spin;
import io.openbpm.spin.plugin.impl.SpinConfiguration;
import io.openbpm.spin.plugin.impl.SpinFallbackSerializerFactory;
import io.openbpm.spin.plugin.impl.SpinScriptEnvResolver;
import io.openbpm.spin.plugin.impl.SpinVariableSerializers;
import io.openbpm.spin.plugin.variable.type.SpinValueType;
import java.util.HashMap;
import java.util.List;

public class SpinProcessEnginePlugin
extends SpinConfiguration {
    public void preInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ClassLoader classloader = ClassLoaderUtil.getClassloader(SpinProcessEnginePlugin.class);
        HashMap<String, Boolean> configurationOptions = new HashMap<String, Boolean>();
        configurationOptions.put("xxe-processing", this.isEnableXxeProcessing());
        configurationOptions.put("secure-processing", this.isEnableSecureXmlProcessing());
        DataFormats.loadDataFormats((ClassLoader)classloader, configurationOptions);
    }

    public void postInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.registerFunctionMapper(processEngineConfiguration);
        this.registerScriptResolver(processEngineConfiguration);
        this.registerSerializers(processEngineConfiguration);
        this.registerValueTypes(processEngineConfiguration);
        this.registerFallbackSerializer(processEngineConfiguration);
    }

    protected void registerFallbackSerializer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.setFallbackSerializerFactory((VariableSerializerFactory)new SpinFallbackSerializerFactory());
    }

    protected void registerSerializers(ProcessEngineConfigurationImpl processEngineConfiguration) {
        List<TypedValueSerializer<?>> spinDataFormatSerializers = this.lookupSpinSerializers();
        VariableSerializers variableSerializers = processEngineConfiguration.getVariableSerializers();
        int javaObjectSerializerIdx = variableSerializers.getSerializerIndexByName("serializable");
        for (TypedValueSerializer<?> spinSerializer : spinDataFormatSerializers) {
            variableSerializers.addSerializer(spinSerializer, javaObjectSerializerIdx);
        }
    }

    protected List<TypedValueSerializer<?>> lookupSpinSerializers() {
        DataFormats globalFormats = DataFormats.getInstance();
        List<TypedValueSerializer<?>> serializers = SpinVariableSerializers.createObjectValueSerializers(globalFormats);
        serializers.addAll(SpinVariableSerializers.createSpinValueSerializers(globalFormats));
        return serializers;
    }

    protected void registerScriptResolver(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getEnvScriptResolvers().add(new SpinScriptEnvResolver());
    }

    protected void registerFunctionMapper(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        expressionManager.addFunction("S", ReflectUtil.getMethod(Spin.class, (String)"S", (Class[])new Class[]{Object.class}));
        expressionManager.addFunction("XML", ReflectUtil.getMethod(Spin.class, (String)"XML", (Class[])new Class[]{Object.class}));
        expressionManager.addFunction("JSON", ReflectUtil.getMethod(Spin.class, (String)"JSON", (Class[])new Class[]{Object.class}));
    }

    protected void registerValueTypes(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ValueTypeResolver resolver = processEngineConfiguration.getValueTypeResolver();
        resolver.addType((ValueType)SpinValueType.JSON);
        resolver.addType((ValueType)SpinValueType.XML);
    }
}

