/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.engine.impl.variable.serializer.ValueFields;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.spin.DataFormats;
import io.openbpm.spin.plugin.impl.SpinValueSerializer;
import io.openbpm.spin.plugin.variable.SpinValues;
import io.openbpm.spin.plugin.variable.type.SpinValueType;
import io.openbpm.spin.plugin.variable.value.SpinValue;
import io.openbpm.spin.plugin.variable.value.impl.XmlValueImpl;
import io.openbpm.spin.spi.DataFormat;
import io.openbpm.spin.xml.SpinXmlElement;

public class XmlValueSerializer
extends SpinValueSerializer {
    public XmlValueSerializer(DataFormat<SpinXmlElement> dataFormat) {
        super(SpinValueType.XML, dataFormat, "xml");
    }

    public XmlValueSerializer() {
        this((DataFormat<SpinXmlElement>)DataFormats.xml());
    }

    public SpinValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (SpinValue)SpinValues.xmlValue((SpinXmlElement)untypedValue.getValue()).create();
    }

    protected SpinValue createDeserializedValue(Object deserializedObject, String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        SpinXmlElement value = (SpinXmlElement)deserializedObject;
        XmlValueImpl xmlValue = new XmlValueImpl(value, serializedStringValue, value.getDataFormatName(), true);
        xmlValue.setTransient(asTransientValue);
        return xmlValue;
    }

    protected SpinValue createSerializedValue(String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        XmlValueImpl xmlValue = new XmlValueImpl(serializedStringValue, this.serializationDataFormat);
        xmlValue.setTransient(asTransientValue);
        return xmlValue;
    }
}

