/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.json.jackson.format;

import io.openbpm.commons.utils.EnsureUtil;
import io.openbpm.spin.impl.json.jackson.JacksonJsonLogger;
import io.openbpm.spin.impl.json.jackson.JacksonJsonNode;
import io.openbpm.spin.impl.json.jackson.format.DefaultJsonJacksonTypeDetector;
import io.openbpm.spin.impl.json.jackson.format.JacksonJsonDataFormatMapper;
import io.openbpm.spin.impl.json.jackson.format.JacksonJsonDataFormatReader;
import io.openbpm.spin.impl.json.jackson.format.JacksonJsonDataFormatWriter;
import io.openbpm.spin.impl.json.jackson.format.ListJacksonJsonTypeDetector;
import io.openbpm.spin.json.SpinJsonNode;
import io.openbpm.spin.spi.DataFormat;
import io.openbpm.spin.spi.TypeDetector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;
import spinjar.com.fasterxml.jackson.databind.node.ArrayNode;
import spinjar.com.fasterxml.jackson.databind.node.ObjectNode;
import spinjar.com.fasterxml.jackson.databind.type.TypeFactory;
import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import spinjar.com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;

public class JacksonJsonDataFormat
implements DataFormat<SpinJsonNode> {
    public static final String DATA_FORMAT_NAME = "application/json";
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected ObjectMapper objectMapper;
    protected Configuration jsonPathConfiguration;
    protected List<TypeDetector> typeDetectors;
    protected JacksonJsonDataFormatReader dataFormatReader;
    protected JacksonJsonDataFormatWriter dataFormatWriter;
    protected JacksonJsonDataFormatMapper dataFormatMapper;
    protected final String name;

    public JacksonJsonDataFormat(String name) {
        this(name, new ObjectMapper());
    }

    public JacksonJsonDataFormat(String name, ObjectMapper objectMapper) {
        this(name, objectMapper, new Configuration.ConfigurationBuilder().jsonProvider(new JacksonJsonProvider(objectMapper)).mappingProvider(new JacksonMappingProvider(objectMapper)).build());
    }

    public JacksonJsonDataFormat(String name, ObjectMapper objectMapper, Configuration jsonPathConfiguration) {
        this.name = name;
        this.objectMapper = objectMapper;
        this.jsonPathConfiguration = jsonPathConfiguration;
        this.init();
    }

    protected void init() {
        this.initReader();
        this.initWriter();
        this.initMapper();
        this.initTypeDetectors();
    }

    protected void initMapper() {
        this.dataFormatMapper = new JacksonJsonDataFormatMapper(this);
    }

    protected void initWriter() {
        this.dataFormatWriter = new JacksonJsonDataFormatWriter(this);
    }

    protected void initReader() {
        this.dataFormatReader = new JacksonJsonDataFormatReader(this);
    }

    protected void initTypeDetectors() {
        this.typeDetectors = new ArrayList<TypeDetector>();
        this.typeDetectors.add(new ListJacksonJsonTypeDetector());
        this.typeDetectors.add(new DefaultJsonJacksonTypeDetector());
    }

    public String getName() {
        return DATA_FORMAT_NAME;
    }

    public Class<? extends SpinJsonNode> getWrapperType() {
        return JacksonJsonNode.class;
    }

    public SpinJsonNode createWrapperInstance(Object parameter) {
        return new JacksonJsonNode((JsonNode)parameter, this);
    }

    public String getCanonicalTypeName(Object object) {
        EnsureUtil.ensureNotNull((String)"object", (Object)object);
        for (TypeDetector typeDetector : this.typeDetectors) {
            if (!typeDetector.canHandle(object)) continue;
            return typeDetector.detectType(object);
        }
        throw LOG.unableToDetectCanonicalType(object);
    }

    public JavaType constructJavaTypeFromCanonicalString(String canonicalString) {
        try {
            return TypeFactory.defaultInstance().constructFromCanonical(canonicalString);
        }
        catch (IllegalArgumentException e) {
            throw LOG.unableToConstructJavaType(canonicalString, e);
        }
    }

    public void addTypeDetector(TypeDetector typeDetector) {
        this.typeDetectors.add(0, typeDetector);
    }

    public JacksonJsonDataFormatMapper getMapper() {
        return this.dataFormatMapper;
    }

    public JacksonJsonDataFormatReader getReader() {
        return this.dataFormatReader;
    }

    public JacksonJsonDataFormatWriter getWriter() {
        return this.dataFormatWriter;
    }

    public Configuration getJsonPathConfiguration() {
        return this.jsonPathConfiguration;
    }

    public void setJsonPathConfiguration(Configuration jsonPathConfiguration) {
        this.jsonPathConfiguration = jsonPathConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonNode createJsonNode(Object parameter) {
        if (parameter instanceof SpinJsonNode) {
            SpinJsonNode jsonNode = (SpinJsonNode)parameter;
            return (JsonNode)jsonNode.unwrap();
        }
        if (parameter instanceof String) {
            String string = (String)parameter;
            return this.createJsonNode(string);
        }
        if (parameter instanceof Integer) {
            Integer integer = (Integer)parameter;
            return this.createJsonNode(integer);
        }
        if (parameter instanceof Boolean) {
            Boolean booleanParameter = (Boolean)parameter;
            return this.createJsonNode(booleanParameter);
        }
        if (parameter instanceof Float) {
            Float floatParameter = (Float)parameter;
            return this.createJsonNode(floatParameter);
        }
        if (parameter instanceof Long) {
            Long longParameter = (Long)parameter;
            return this.createJsonNode(longParameter);
        }
        if (parameter instanceof Number) {
            Number numberParameter = (Number)parameter;
            return this.createJsonNode(numberParameter.doubleValue());
        }
        if (parameter instanceof List) {
            List listParameter = (List)parameter;
            return this.createJsonNode(listParameter);
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            return this.createJsonNode(map);
        }
        if (parameter == null) {
            return this.createNullJsonNode();
        }
        throw LOG.unableToCreateNode(parameter.getClass().getSimpleName());
    }

    public JsonNode createJsonNode(String parameter) {
        return this.objectMapper.getNodeFactory().textNode(parameter);
    }

    public JsonNode createJsonNode(Integer parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Float parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Double parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Long parameter) {
        return this.objectMapper.getNodeFactory().numberNode(parameter);
    }

    public JsonNode createJsonNode(Boolean parameter) {
        return this.objectMapper.getNodeFactory().booleanNode(parameter);
    }

    public JsonNode createJsonNode(List<Object> parameter) {
        if (parameter != null) {
            ArrayNode node = this.objectMapper.getNodeFactory().arrayNode();
            for (Object entry : parameter) {
                node.add(this.createJsonNode(entry));
            }
            return node;
        }
        return this.createNullJsonNode();
    }

    public JsonNode createJsonNode(Map<String, Object> parameter) {
        if (parameter != null) {
            ObjectNode node = this.objectMapper.getNodeFactory().objectNode();
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                node.set(entry.getKey(), this.createJsonNode(entry.getValue()));
            }
            return node;
        }
        return this.createNullJsonNode();
    }

    public JsonNode createNullJsonNode() {
        return this.objectMapper.getNodeFactory().nullNode();
    }
}

