/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.json.jackson.format;

import io.openbpm.spin.impl.json.jackson.JacksonJsonLogger;
import io.openbpm.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import io.openbpm.spin.spi.TextBasedDataFormatReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;
import spinjar.com.fasterxml.jackson.databind.node.MissingNode;

public class JacksonJsonDataFormatReader
extends TextBasedDataFormatReader {
    private static final JacksonJsonLogger JSON_LOGGER = JacksonJsonLogger.JSON_TREE_LOGGER;
    private static final Pattern INPUT_MATCHING_PATTERN = Pattern.compile("\\A(\\s)*[{\\[]");
    protected JacksonJsonDataFormat format;

    public JacksonJsonDataFormatReader(JacksonJsonDataFormat format) {
        this.format = format;
    }

    public Object readInput(Reader input) {
        ObjectMapper mapper = this.format.getObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(input);
            if (jsonNode instanceof MissingNode) {
                throw new IOException("Input is empty");
            }
            return jsonNode;
        }
        catch (IOException e) {
            throw JSON_LOGGER.unableToParseInput(e);
        }
    }

    protected Pattern getInputDetectionPattern() {
        return INPUT_MATCHING_PATTERN;
    }
}

