/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.xml.dom.query;

import io.openbpm.commons.utils.EnsureUtil;
import io.openbpm.spin.xml.SpinXmlElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class DomXPathNamespaceResolver
implements NamespaceContext {
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected SpinXmlElement element;

    public DomXPathNamespaceResolver(SpinXmlElement element) {
        this.element = element;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        EnsureUtil.ensureNotNull((String)"Prefix", (Object)prefix);
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if ("".equals(prefix)) {
            return this.element.namespace();
        }
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        if (namespaceURI.equals(this.element.name())) {
            return "";
        }
        String key = null;
        if (this.namespaces.containsValue(namespaceURI)) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                key = entry.getKey();
                break;
            }
        }
        return key;
    }

    public Iterator getPrefixes(String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        ArrayList<String> list = new ArrayList<String>();
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            list.add("xml");
            return Collections.unmodifiableList(list).iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            list.add("xmlns");
            return Collections.unmodifiableList(list).iterator();
        }
        if (namespaceURI.equals(this.element.namespace())) {
            list.add("");
        }
        if (this.namespaces.containsValue(namespaceURI)) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                if (!namespaceURI.equals(entry.getValue())) continue;
                list.add(entry.getKey());
            }
        }
        return Collections.unmodifiableList(list).iterator();
    }

    public void setNamespace(String prefix, String namespaceURI) {
        EnsureUtil.ensureNotNull((String)"Prefix", (Object)prefix);
        EnsureUtil.ensureNotNull((String)"Namespace URI", (Object)namespaceURI);
        this.namespaces.put(prefix, namespaceURI);
    }

    public void setNamespaces(Map<String, String> namespaces) {
        EnsureUtil.ensureNotNull((String)"Namespaces", namespaces);
        this.namespaces = namespaces;
    }
}

