/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.fasterxml.jackson.databind;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import spinjar.com.fasterxml.jackson.databind.BeanProperty;
import spinjar.com.fasterxml.jackson.databind.DeserializationContext;
import spinjar.com.fasterxml.jackson.databind.DeserializationFeature;
import spinjar.com.fasterxml.jackson.databind.JsonMappingException;
import spinjar.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class InjectableValues {
    public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) throws JsonMappingException {
        return this.findInjectableValue(valueId, ctxt, forProperty, beanInstance);
    }

    @Deprecated
    public abstract Object findInjectableValue(Object var1, DeserializationContext var2, BeanProperty var3, Object var4) throws JsonMappingException;

    public static class Std
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> values) {
            this._values = values;
        }

        public Std addValue(String key, Object value) {
            this._values.put(key, value);
            return this;
        }

        public Std addValue(Class<?> classKey, Object value) {
            this._values.put(classKey.getName(), value);
            return this;
        }

        @Override
        public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) throws JsonMappingException {
            if (!(valueId instanceof String)) {
                throw ctxt.missingInjectableValueException(String.format("Unsupported injectable value id type (%s), expecting String", ClassUtil.classNameOf(valueId)), valueId, forProperty, beanInstance);
            }
            String key = (String)valueId;
            Object ob = this._values.get(key);
            if (ob == null && !this._values.containsKey(key) && (Boolean.FALSE.equals(optional) || optional == null && ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_INJECT_VALUE))) {
                throw ctxt.missingInjectableValueException(String.format("No injectable value with id '%s' found (for property '%s')", key, forProperty.getName()), valueId, forProperty, beanInstance);
            }
            return ob;
        }

        @Override
        @Deprecated
        public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) throws JsonMappingException {
            return this.findInjectableValue(ctxt, valueId, forProperty, beanInstance, null, null);
        }
    }
}

