/*
 * Decompiled with CFR 0.152.
 */
package spinjar.org.eclipse.angus.activation;

import java.util.logging.Level;
import java.util.logging.Logger;

class LogSupport {
    private static boolean debug = false;
    private static Logger logger;
    private static final Level level;

    private LogSupport() {
    }

    public static void log(String msg) {
        if (!LogSupport.isLoggable()) {
            return;
        }
        if (debug) {
            System.out.println(msg);
        }
        logger.log(level, msg);
    }

    public static void log(String msg, Throwable t) {
        if (!LogSupport.isLoggable()) {
            return;
        }
        if (debug) {
            System.out.println(msg + "; Exception: " + t);
        }
        logger.log(level, msg, t);
    }

    public static boolean isLoggable() {
        return debug || logger.isLoggable(level);
    }

    static {
        level = Level.FINE;
        try {
            debug = Boolean.getBoolean("angus.activation.debug");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger = Logger.getLogger("angus.activation");
    }
}

