/*
 * Decompiled with CFR 0.152.
 */
package spinjar.org.eclipse.angus.activation.nativeimage;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import spinjar.org.eclipse.angus.activation.MailcapFile;

public class AngusActivationFeature
implements Feature {
    private static final boolean ENABLED = AngusActivationFeature.getOption("angus.activation.native-image.enable", true);
    private static final boolean DEBUG = AngusActivationFeature.getOption("angus.activation.native-image.trace", false);
    private static final List<String> RESOURCES = Arrays.asList("META-INF/jakarta.mailcap", "META-INF/jakarta.mailcap.default");
    private static final List<String> RESOURCES_OLD = Arrays.asList("META-INF/mailcap", "META-INF/mailcap.default");

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ENABLED;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Set<String> commands = AngusActivationFeature.commands(access, RESOURCES);
        if (commands.isEmpty()) {
            commands = AngusActivationFeature.commands(access, RESOURCES_OLD);
        }
        commands.forEach(command -> {
            Class cls = access.findClassByName(command);
            if (cls != null) {
                AngusActivationFeature.log(() -> "Registering " + cls);
                try {
                    RuntimeReflection.register((Class[])new Class[]{cls});
                    RuntimeReflection.register((Executable[])new Executable[]{cls.getConstructor(new Class[0])});
                }
                catch (NoSuchMethodException e) {
                    AngusActivationFeature.log(() -> "\tno constructor for " + cls);
                }
            } else {
                AngusActivationFeature.log(() -> "Class for '" + command + "' not found");
            }
        });
    }

    private static Set<String> commands(Feature.BeforeAnalysisAccess access, List<String> resources) {
        HashSet<String> commands = new HashSet<String>();
        for (String resource : resources) {
            AngusActivationFeature.log(() -> "looking for " + resource);
            try {
                Enumeration<URL> urls = access.getApplicationClassLoader().getResources(resource);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    AngusActivationFeature.log(() -> "processing " + url);
                    InputStream is = url.openStream();
                    try {
                        MailcapFile mf = new MailcapFile(is);
                        for (String mimeType : mf.getMimeTypes()) {
                            Map<String, List<String>> map = mf.getMailcapList(mimeType);
                            if (map != null) {
                                map.values().forEach(list -> list.forEach(commands::add));
                            }
                            if ((map = mf.getMailcapFallbackList(mimeType)) == null) continue;
                            map.values().forEach(list -> list.forEach(commands::add));
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return commands;
    }

    private static boolean getOption(String name, boolean def) {
        String prop = System.getProperty(name);
        if (prop == null) {
            return def;
        }
        return Boolean.parseBoolean(name);
    }

    private static void log(Supplier<String> msg) {
        if (DEBUG) {
            System.out.println(msg.get());
        }
    }
}

