/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.plugin.impl;

import io.openbpm.bpm.engine.BpmnParseException;
import io.openbpm.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import io.openbpm.bpm.engine.impl.bpmn.parser.BpmnParseUtil;
import io.openbpm.bpm.engine.impl.core.variable.mapping.IoMapping;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.util.xml.Element;
import io.openbpm.connect.plugin.impl.ServiceTaskConnectorActivityBehavior;

public class ConnectorParseListener
implements BpmnParseListener {
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(serviceTaskElement, scope, activity);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        Element messageEventDefinitionElement = endEventElement.element("messageEventDefinition");
        if (messageEventDefinitionElement != null) {
            this.parseConnectorElement(messageEventDefinitionElement, scope, activity);
        }
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        Element messageEventDefinitionElement = intermediateEventElement.element("messageEventDefinition");
        if (messageEventDefinitionElement != null) {
            this.parseConnectorElement(messageEventDefinitionElement, scope, activity);
        }
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(businessRuleTaskElement, scope, activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.parseConnectorElement(sendTaskElement, scope, activity);
    }

    protected void parseConnectorElement(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        Element connectorDefinition = BpmnParseUtil.findOperatonExtensionElement((Element)serviceTaskElement, (String)"connector");
        if (connectorDefinition != null) {
            Element connectorIdElement = connectorDefinition.element("connectorId");
            String connectorId = null;
            if (connectorIdElement != null) {
                connectorId = connectorIdElement.getText().trim();
            }
            if (connectorIdElement == null || connectorId.isEmpty()) {
                throw new BpmnParseException("No 'id' defined for connector.", connectorDefinition);
            }
            IoMapping ioMapping = BpmnParseUtil.parseInputOutput((Element)connectorDefinition);
            activity.setActivityBehavior((ActivityBehavior)new ServiceTaskConnectorActivityBehavior(connectorId, ioMapping));
        }
    }
}

