/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.builtins.math.AsinNode;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=AsinNode.class)
public final class AsinNodeGen
extends AsinNode {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private AsinNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && (state_0 & 3) != 0) {
            return this.execute_double0(state_0, frameValue);
        }
        return this.execute_generic1(state_0, frameValue);
    }

    private Object execute_double0(int state_0__, VirtualFrame frameValue) {
        double arguments0Value_;
        int state_0 = state_0__;
        int arguments0Value_int = 0;
        try {
            if ((state_0 & 0x18) == 0 && (state_0 & 3) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else if ((state_0 & 0x14) == 0 && (state_0 & 3) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1C) >>> 2, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return AsinNode.asinDouble(arguments0Value_);
    }

    private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state_0 & 3) != 0) {
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                double arguments0Value__ = JSTypesGen.asImplicitDouble((state_0 & 0x1C) >>> 2, arguments0Value_);
                return AsinNode.asinDouble(arguments0Value__);
            }
            if ((state_0 & 2) != 0) {
                return this.asinGeneric(arguments0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    private double executeAndSpecialize(Object arguments0Value) {
        int state_0 = this.state_0_;
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
        if (doubleCast0 != 0) {
            double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
            state_0 |= doubleCast0 << 2;
            this.state_0_ = state_0 |= 1;
            return AsinNode.asinDouble(arguments0Value_);
        }
        this.state_0_ = state_0 |= 2;
        return this.asinGeneric(arguments0Value);
    }

    @NeverDefault
    public static AsinNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new AsinNodeGen(context, builtin, arguments);
    }
}

