/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application.impl;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationExecutionException;
import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.ClassLoaderUtil;
import java.util.concurrent.Callable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class AbstractEjbProcessApplication
extends AbstractProcessApplication {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected static final String MODULE_NAME_PATH = "java:module/ModuleName";
    protected static final String JAVA_APP_APP_NAME_PATH = "java:app/AppName";
    protected static final String EJB_CONTEXT_PATH = "java:comp/EJBContext";
    protected ProcessApplicationInterface selfReference;

    @Override
    public ProcessApplicationReference getReference() {
        this.ensureInitialized();
        return this.getEjbProcessApplicationReference();
    }

    @Override
    protected String autodetectProcessApplicationName() {
        return this.lookupEeApplicationName();
    }

    protected Class<? extends ProcessApplicationInterface> getBusinessInterface() {
        return ProcessApplicationInterface.class;
    }

    @Override
    public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
        ClassLoader originalClassloader = ClassLoaderUtil.getContextClassloader();
        ClassLoader processApplicationClassloader = this.getProcessApplicationClassloader();
        try {
            if (originalClassloader != processApplicationClassloader) {
                ClassLoaderUtil.setContextClassloader(processApplicationClassloader);
            }
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw LOG.processApplicationExecutionException(e);
        }
        finally {
            ClassLoaderUtil.setContextClassloader(originalClassloader);
        }
    }

    protected void ensureInitialized() {
        if (this.selfReference == null) {
            this.selfReference = this.lookupSelfReference();
        }
        this.ensureEjbProcessApplicationReferenceInitialized();
    }

    protected abstract void ensureEjbProcessApplicationReferenceInitialized();

    protected abstract ProcessApplicationReference getEjbProcessApplicationReference();

    protected abstract ProcessApplicationInterface lookupSelfReference();

    protected String lookupEeApplicationName() {
        try {
            InitialContext initialContext = new InitialContext();
            String appName = (String)initialContext.lookup(JAVA_APP_APP_NAME_PATH);
            String moduleName = (String)initialContext.lookup(MODULE_NAME_PATH);
            if (moduleName != null && !moduleName.equals(appName)) {
                return appName + "/" + moduleName;
            }
            return appName;
        }
        catch (NamingException e) {
            throw LOG.ejbPaCannotAutodetectName(e);
        }
    }
}

