/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application.impl;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplication;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractServletProcessApplicationDeployer {
    protected static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    protected void onStartUp(Set<Class<?>> c, String contextPath, Class<?> servletProcessApplicationClass, Consumer<String> processApplicationClassNameConsumer) throws Exception {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (c.contains(ProcessApplication.class)) {
            c = new HashSet(c);
            c.remove(ProcessApplication.class);
        }
        if (c.size() > 1) {
            throw this.getServletException(LOG.multiplePasException(c, contextPath));
        }
        if (c.size() == 1) {
            Class<?> paClass = c.iterator().next();
            if (!AbstractProcessApplication.class.isAssignableFrom(paClass)) {
                throw this.getServletException(LOG.paWrongTypeException(paClass));
            }
            if (servletProcessApplicationClass.isAssignableFrom(paClass)) {
                LOG.detectedPa(paClass);
                processApplicationClassNameConsumer.accept(paClass.getName());
            }
        } else {
            LOG.servletDeployerNoPaFound(contextPath);
        }
    }

    protected abstract Exception getServletException(String var1);
}

