/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application.impl;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationElResolver;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ServiceLoader;

public final class DefaultElResolverLookup {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    private DefaultElResolverLookup() {
    }

    public static ELResolver lookupResolver(AbstractProcessApplication processApplication) {
        ServiceLoader<ProcessApplicationElResolver> providers = ServiceLoader.load(ProcessApplicationElResolver.class);
        ArrayList<ProcessApplicationElResolver> sortedProviders = new ArrayList<ProcessApplicationElResolver>();
        for (ProcessApplicationElResolver provider : providers) {
            sortedProviders.add(provider);
        }
        if (sortedProviders.isEmpty()) {
            return null;
        }
        Collections.sort(sortedProviders, new ProcessApplicationElResolver.ProcessApplicationElResolverSorter());
        CompositeELResolver compositeResolver = new CompositeELResolver();
        StringBuilder summary = new StringBuilder();
        summary.append("ElResolvers found for Process Application %s".formatted(processApplication.getName()));
        for (ProcessApplicationElResolver processApplicationElResolver : sortedProviders) {
            ELResolver elResolver = processApplicationElResolver.getElResolver(processApplication);
            if (elResolver != null) {
                compositeResolver.add(elResolver);
                summary.append("Class %s".formatted(processApplicationElResolver.getClass().getName()));
                continue;
            }
            LOG.noElResolverProvided(processApplication.getName(), processApplicationElResolver.getClass().getName());
        }
        LOG.paElResolversDiscovered(summary.toString());
        return compositeResolver;
    }
}

