/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application.impl;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.ProcessApplicationUnavailableException;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.lang.ref.WeakReference;

public class ProcessApplicationReferenceImpl
implements ProcessApplicationReference {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected WeakReference<AbstractProcessApplication> processApplication;
    protected String name;

    public ProcessApplicationReferenceImpl(AbstractProcessApplication processApplication) {
        this.processApplication = new WeakReference<AbstractProcessApplication>(processApplication);
        this.name = processApplication.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractProcessApplication getProcessApplication() throws ProcessApplicationUnavailableException {
        AbstractProcessApplication application = (AbstractProcessApplication)this.processApplication.get();
        if (application == null) {
            throw LOG.processApplicationUnavailableException(this.name);
        }
        return application;
    }

    public void processEngineStopping(ProcessEngine processEngine) {
    }

    public void clear() {
        this.processApplication.clear();
    }
}

