/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application.impl.event;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.ProcessApplicationUnavailableException;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.delegate.DelegateTask;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.delegate.TaskListener;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import java.util.concurrent.Callable;

public class ProcessApplicationEventListenerDelegate
implements ExecutionListener,
TaskListener {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        Callable<Void> notification = () -> {
            this.notifyExecutionListener(execution);
            return null;
        };
        this.performNotification(execution, notification);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        if (delegateTask.getExecution() == null) {
            LOG.taskNotRelatedToExecution(delegateTask);
        } else {
            DelegateExecution execution = delegateTask.getExecution();
            Callable<Void> notification = () -> {
                this.notifyTaskListener(delegateTask);
                return null;
            };
            try {
                this.performNotification(execution, notification);
            }
            catch (Exception e) {
                throw LOG.exceptionWhileNotifyingPaTaskListener(e);
            }
        }
    }

    protected void performNotification(DelegateExecution execution, Callable<Void> notification) throws Exception {
        ProcessApplicationReference processApp = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (processApp == null) {
            LOG.noTargetProcessApplicationForExecution(execution);
        } else if (ProcessApplicationContextUtil.requiresContextSwitch(processApp)) {
            Context.executeWithinProcessApplication(notification, processApp, new InvocationContext(execution));
        } else {
            notification.call();
        }
    }

    protected void notifyExecutionListener(DelegateExecution execution) throws Exception {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            ExecutionListener executionListener = processApplication.getExecutionListener();
            if (executionListener != null) {
                executionListener.notify(execution);
            } else {
                LOG.paDoesNotProvideExecutionListener(processApp.getName());
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            LOG.cannotInvokeListenerPaUnavailable(processApp.getName(), e);
        }
    }

    protected void notifyTaskListener(DelegateTask task) {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            TaskListener taskListener = processApplication.getTaskListener();
            if (taskListener != null) {
                taskListener.notify(task);
            } else {
                LOG.paDoesNotProvideTaskListener(processApp.getName());
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            LOG.cannotInvokeListenerPaUnavailable(processApp.getName(), e);
        }
    }
}

