/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.spi;

import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentOperation {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final String name;
    protected final PlatformServiceContainer serviceContainer;
    protected final List<DeploymentOperationStep> steps;
    protected final List<DeploymentOperationStep> successfulSteps = new ArrayList<DeploymentOperationStep>();
    protected List<String> installedServices = new ArrayList<String>();
    protected Map<String, Object> attachments = new HashMap<String, Object>();
    protected boolean isRollbackOnFailure = true;
    protected DeploymentOperationStep currentStep;

    public DeploymentOperation(String name, PlatformServiceContainer container, List<DeploymentOperationStep> steps) {
        this.name = name;
        this.serviceContainer = container;
        this.steps = steps;
    }

    public <S> S getAttachment(String name) {
        return (S)this.attachments.get(name);
    }

    public void addAttachment(String name, Object value) {
        this.attachments.put(name, value);
    }

    public void addStep(DeploymentOperationStep step) {
        if (this.currentStep != null) {
            this.steps.add(this.steps.indexOf(this.currentStep) + 1, step);
        } else {
            this.steps.add(step);
        }
    }

    public void serviceAdded(String serviceName) {
        this.installedServices.add(serviceName);
    }

    public PlatformServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public void execute() {
        while (!this.steps.isEmpty()) {
            this.currentStep = this.steps.remove(0);
            try {
                LOG.debugPerformOperationStep(this.currentStep.getName());
                this.currentStep.performOperationStep(this);
                this.successfulSteps.add(this.currentStep);
                LOG.debugSuccessfullyPerformedOperationStep(this.currentStep.getName());
            }
            catch (Exception e) {
                if (this.isRollbackOnFailure) {
                    try {
                        this.rollbackOperation();
                    }
                    catch (Exception e2) {
                        LOG.exceptionWhileRollingBackOperation(e2);
                    }
                    throw LOG.exceptionWhilePerformingOperationStep(this.name, this.currentStep.getName(), e);
                }
                LOG.exceptionWhilePerformingOperationStep(this.currentStep.getName(), e);
            }
        }
    }

    protected void rollbackOperation() {
        for (DeploymentOperationStep step : this.successfulSteps) {
            try {
                step.cancelOperationStep(this);
            }
            catch (Exception e) {
                LOG.exceptionWhileRollingBackOperation(e);
            }
        }
        for (String serviceName : this.installedServices) {
            try {
                this.serviceContainer.stopService(serviceName);
            }
            catch (Exception e) {
                LOG.exceptionWhileStopping("service", serviceName, e);
            }
        }
    }

    public List<String> getInstalledServices() {
        return this.installedServices;
    }

    public static class DeploymentOperationBuilder {
        protected PlatformServiceContainer container;
        protected String name;
        protected boolean isUndeploymentOperation;
        protected List<DeploymentOperationStep> steps = new ArrayList<DeploymentOperationStep>();
        protected Map<String, Object> initialAttachments = new HashMap<String, Object>();

        public DeploymentOperationBuilder(PlatformServiceContainer container, String name) {
            this.container = container;
            this.name = name;
        }

        public DeploymentOperationBuilder addStep(DeploymentOperationStep step) {
            this.steps.add(step);
            return this;
        }

        public DeploymentOperationBuilder addSteps(Collection<DeploymentOperationStep> steps) {
            for (DeploymentOperationStep step : steps) {
                this.addStep(step);
            }
            return this;
        }

        public DeploymentOperationBuilder addAttachment(String name, Object value) {
            this.initialAttachments.put(name, value);
            return this;
        }

        public DeploymentOperationBuilder setUndeploymentOperation() {
            this.isUndeploymentOperation = true;
            return this;
        }

        public void execute() {
            DeploymentOperation operation = new DeploymentOperation(this.name, this.container, this.steps);
            operation.isRollbackOnFailure = !this.isUndeploymentOperation;
            operation.attachments.putAll(this.initialAttachments);
            this.container.executeDeploymentOperation(operation);
        }
    }
}

