/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.threading.se;

import io.openbpm.bpm.container.ExecutorService;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.engine.impl.ProcessEngineImpl;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.ExecuteJobsRunnable;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class SeExecutorService
implements ExecutorService {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected ThreadPoolExecutor threadPoolExecutor;

    public SeExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public boolean schedule(Runnable runnable, boolean isLongRunning) {
        if (isLongRunning) {
            return this.executeLongRunning(runnable);
        }
        return this.executeShortRunning(runnable);
    }

    protected boolean executeLongRunning(Runnable runnable) {
        new Thread(runnable).start();
        return true;
    }

    protected boolean executeShortRunning(Runnable runnable) {
        try {
            this.threadPoolExecutor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.debugRejectedExecutionException(e);
            return false;
        }
    }

    @Override
    public Runnable getExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        return new ExecuteJobsRunnable(jobIds, processEngine);
    }
}

