/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.tomcat;

import io.openbpm.bpm.container.RuntimeContainerDelegate;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.RuntimeContainerDelegateImpl;
import io.openbpm.bpm.container.impl.deployment.DiscoverBpmPlatformPluginsStep;
import io.openbpm.bpm.container.impl.deployment.PlatformXmlStartProcessEnginesStep;
import io.openbpm.bpm.container.impl.deployment.StopProcessApplicationsStep;
import io.openbpm.bpm.container.impl.deployment.StopProcessEnginesStep;
import io.openbpm.bpm.container.impl.deployment.UnregisterBpmPlatformPluginsStep;
import io.openbpm.bpm.container.impl.deployment.jobexecutor.StartJobExecutorStep;
import io.openbpm.bpm.container.impl.deployment.jobexecutor.StartManagedThreadPoolStep;
import io.openbpm.bpm.container.impl.deployment.jobexecutor.StopJobExecutorStep;
import io.openbpm.bpm.container.impl.deployment.jobexecutor.StopManagedThreadPoolStep;
import io.openbpm.bpm.container.impl.tomcat.deployment.TomcatParseBpmPlatformXmlStep;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;

public class TomcatBpmPlatformBootstrap
implements LifecycleListener {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected ProcessEngine processEngine;
    protected RuntimeContainerDelegateImpl containerDelegate;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.containerDelegate = (RuntimeContainerDelegateImpl)RuntimeContainerDelegate.INSTANCE.get();
            this.deployBpmPlatform(event);
        } else if ("stop".equals(event.getType())) {
            this.undeployBpmPlatform(event);
        }
    }

    protected void deployBpmPlatform(LifecycleEvent event) {
        StandardServer server = (StandardServer)event.getSource();
        this.containerDelegate.getServiceContainer().createDeploymentOperation("deploy BPM platform").addAttachment("server", server).addStep(new TomcatParseBpmPlatformXmlStep()).addStep(new DiscoverBpmPlatformPluginsStep()).addStep(new StartManagedThreadPoolStep()).addStep(new StartJobExecutorStep()).addStep(new PlatformXmlStartProcessEnginesStep()).execute();
        LOG.operatonBpmPlatformSuccessfullyStarted(server.getServerInfo());
    }

    protected void undeployBpmPlatform(LifecycleEvent event) {
        StandardServer server = (StandardServer)event.getSource();
        this.containerDelegate.getServiceContainer().createUndeploymentOperation("undeploy BPM platform").addAttachment("server", server).addStep(new StopJobExecutorStep()).addStep(new StopManagedThreadPoolStep()).addStep(new StopProcessApplicationsStep()).addStep(new StopProcessEnginesStep()).addStep(new UnregisterBpmPlatformPluginsStep()).execute();
        LOG.operatonBpmPlatformStopped(server.getServerInfo());
    }
}

