/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineConfiguration;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.ProcessEngineInfo;
import io.openbpm.bpm.engine.impl.ProcessEngineInfoImpl;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.impl.util.ReflectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ProcessEngines {
    private static final ProcessEngineLogger LOG = ProcessEngineLogger.INSTANCE;
    public static final String NAME_DEFAULT = "default";
    private static volatile boolean isInitialized;
    private static volatile Map<String, ProcessEngine> processEngines;
    private static final Map<String, ProcessEngineInfo> PROCESS_ENGINE_INFOS_BY_NAME;
    private static final Map<String, ProcessEngineInfo> PROCESS_ENGINE_INFOS_BY_RESOURCE_URL;
    private static final List<ProcessEngineInfo> PROCESS_ENGINE_INFOS;

    private ProcessEngines() {
    }

    public static synchronized void init() {
        ProcessEngines.init(true);
    }

    public static synchronized void init(boolean forceCreate) {
        if (!isInitialized) {
            if (processEngines == null) {
                processEngines = new ConcurrentHashMap<String, ProcessEngine>();
            }
            ClassLoader classLoader = ReflectUtil.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("operaton.cfg.xml");
            }
            catch (IOException e) {
                try {
                    resources = classLoader.getResources("activiti.cfg.xml");
                }
                catch (IOException ex) {
                    if (forceCreate) {
                        throw new ProcessEngineException("problem retrieving operaton.cfg.xml and activiti.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), ex);
                    }
                    return;
                }
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                ProcessEngines.initProcessEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("activiti-context.xml");
            }
            catch (IOException e) {
                if (forceCreate) {
                    throw new ProcessEngineException("problem retrieving activiti-context.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
                }
                return;
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                ProcessEngines.initProcessEngineFromSpringResource(resource);
            }
            isInitialized = true;
        } else {
            LOG.processEngineAlreadyInitialized();
        }
    }

    protected static void initProcessEngineFromSpringResource(URL resource) {
        try {
            Class<?> springConfigurationHelperClass = ReflectUtil.loadClass("io.openbpm.bpm.engine.spring.SpringConfigurationHelper");
            Method method = springConfigurationHelperClass.getMethod("buildProcessEngine", URL.class);
            ProcessEngine processEngine = (ProcessEngine)method.invoke(null, resource);
            String processEngineName = processEngine.getName();
            ProcessEngineInfoImpl processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resource.toString(), null);
            PROCESS_ENGINE_INFOS_BY_NAME.put(processEngineName, processEngineInfo);
            PROCESS_ENGINE_INFOS_BY_RESOURCE_URL.put(resource.toString(), processEngineInfo);
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't initialize process engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), e);
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEngines.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEngines.remove(processEngine.getName());
    }

    public static boolean isRegisteredProcessEngine(String processEngineName) {
        return processEngines.containsKey(processEngineName);
    }

    private static ProcessEngineInfo initProcessEngineFromResource(URL resourceUrl) {
        ProcessEngineInfo processEngineInfo = PROCESS_ENGINE_INFOS_BY_RESOURCE_URL.get(resourceUrl.toString());
        if (processEngineInfo != null) {
            PROCESS_ENGINE_INFOS.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEngines.remove(processEngineName);
                PROCESS_ENGINE_INFOS_BY_NAME.remove(processEngineName);
            }
            PROCESS_ENGINE_INFOS_BY_RESOURCE_URL.remove(processEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOG.initializingProcessEngineForResource(resourceUrl);
            ProcessEngine processEngine = ProcessEngines.buildProcessEngine(resourceUrl);
            String processEngineName = processEngine.getName();
            LOG.initializingProcessEngine(processEngine.getName());
            processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resourceUrlString, null);
            processEngines.put(processEngineName, processEngine);
            PROCESS_ENGINE_INFOS_BY_NAME.put(processEngineName, processEngineInfo);
        }
        catch (RuntimeException e) {
            LOG.exceptionWhileInitializingProcessengine(e);
            processEngineInfo = new ProcessEngineInfoImpl(null, resourceUrlString, ProcessEngines.getExceptionString(e));
        }
        PROCESS_ENGINE_INFOS_BY_RESOURCE_URL.put(resourceUrlString, processEngineInfo);
        PROCESS_ENGINE_INFOS.add(processEngineInfo);
        return processEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static ProcessEngine buildProcessEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream);
            ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
            return processEngine;
        }
        catch (IOException e) {
            throw new ProcessEngineException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static List<ProcessEngineInfo> getProcessEngineInfos() {
        return PROCESS_ENGINE_INFOS;
    }

    public static ProcessEngineInfo getProcessEngineInfo(String processEngineName) {
        return PROCESS_ENGINE_INFOS_BY_NAME.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getDefaultProcessEngine(true);
    }

    public static ProcessEngine getDefaultProcessEngine(boolean forceCreate) {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT, forceCreate);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        return ProcessEngines.getProcessEngine(processEngineName, true);
    }

    public static ProcessEngine getProcessEngine(String processEngineName, boolean forceCreate) {
        if (!isInitialized) {
            ProcessEngines.init(forceCreate);
        }
        return processEngines.get(processEngineName);
    }

    public static ProcessEngineInfo retry(String resourceUrl) {
        try {
            return ProcessEngines.initProcessEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ProcessEngineException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEngines;
    }

    public static synchronized void destroy() {
        if (isInitialized) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEngines);
            processEngines = new ConcurrentHashMap<String, ProcessEngine>();
            for (Map.Entry engineEntry : engines.entrySet()) {
                String processEngineName = (String)engineEntry.getKey();
                ProcessEngine processEngine = (ProcessEngine)engineEntry.getValue();
                try {
                    processEngine.close();
                }
                catch (Exception e) {
                    LOG.exceptionWhileClosingProcessEngine((String)(processEngineName == null ? "the default process engine" : "process engine " + processEngineName), e);
                }
            }
            PROCESS_ENGINE_INFOS_BY_NAME.clear();
            PROCESS_ENGINE_INFOS_BY_RESOURCE_URL.clear();
            PROCESS_ENGINE_INFOS.clear();
            isInitialized = false;
        }
    }

    static {
        processEngines = new ConcurrentHashMap<String, ProcessEngine>();
        PROCESS_ENGINE_INFOS_BY_NAME = new ConcurrentHashMap<String, ProcessEngineInfo>();
        PROCESS_ENGINE_INFOS_BY_RESOURCE_URL = new ConcurrentHashMap<String, ProcessEngineInfo>();
        PROCESS_ENGINE_INFOS = new CopyOnWriteArrayList<ProcessEngineInfo>();
    }
}

