/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.QueryOperator;
import io.openbpm.bpm.engine.impl.QueryVariableValue;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializers;
import io.openbpm.bpm.engine.query.Query;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;

    protected AbstractVariableQueryImpl() {
    }

    protected AbstractVariableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public abstract long executeCount(CommandContext var1);

    @Override
    public abstract List<U> executeList(CommandContext var1, Page var2);

    public T variableValueEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.EQUALS, true);
        return (T)this;
    }

    public T variableValueNotEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, true);
        return (T)this;
    }

    public T variableValueGreaterThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, true);
        return (T)this;
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, true);
        return (T)this;
    }

    public T variableValueLessThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, true);
        return (T)this;
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, true);
        return (T)this;
    }

    public T variableValueLike(String name, String value) {
        this.addVariable(name, value, QueryOperator.LIKE, true);
        return (T)this;
    }

    public T variableValueNotLike(String name, String value) {
        this.addVariable(name, value, QueryOperator.NOT_LIKE, true);
        return (T)this;
    }

    public T matchVariableNamesIgnoreCase() {
        this.variableNamesIgnoreCase = true;
        for (QueryVariableValue variable : this.getQueryVariableValues()) {
            variable.setVariableNameIgnoreCase(true);
        }
        return (T)this;
    }

    public T matchVariableValuesIgnoreCase() {
        this.variableValuesIgnoreCase = true;
        for (QueryVariableValue variable : this.getQueryVariableValues()) {
            variable.setVariableValueIgnoreCase(true);
        }
        return (T)this;
    }

    protected void addVariable(String name, Object value, QueryOperator operator, boolean processInstanceScope) {
        QueryVariableValue queryVariableValue = this.createQueryVariableValue(name, value, operator, processInstanceScope);
        this.getQueryVariableValues().add(queryVariableValue);
    }

    protected QueryVariableValue createQueryVariableValue(String name, Object value, QueryOperator operator, boolean processInstanceScope) {
        this.validateVariable(name, value, operator);
        boolean shouldMatchVariableValuesIgnoreCase = Boolean.TRUE.equals(this.variableValuesIgnoreCase) && value != null && String.class.isAssignableFrom(value.getClass());
        boolean shouldMatchVariableNamesIgnoreCase = Boolean.TRUE.equals(this.variableNamesIgnoreCase);
        return new QueryVariableValue(name, value, operator, processInstanceScope, shouldMatchVariableNamesIgnoreCase, shouldMatchVariableValuesIgnoreCase);
    }

    protected void validateVariable(String name, Object value, QueryOperator operator) {
        EnsureUtil.ensureNotNull(NotValidException.class, "name", (Object)name);
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new NotValidException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new NotValidException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new NotValidException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new NotValidException("Booleans and null cannot be used in 'less than or equal' condition");
                }
                case LIKE: {
                    throw new NotValidException("Booleans and null cannot be used in 'like' condition");
                }
                case NOT_LIKE: {
                    throw new NotValidException("Booleans and null cannot be used in 'not like' condition");
                }
            }
        }
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.getQueryVariableValues().isEmpty()) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            VariableSerializers variableSerializers = processEngineConfiguration.getVariableSerializers();
            String dbType = processEngineConfiguration.getDatabaseType();
            for (QueryVariableValue queryVariableValue : this.getQueryVariableValues()) {
                queryVariableValue.initialize(variableSerializers, dbType);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public Boolean isVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public Boolean isVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }
}

