/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.ProcessEngineBootstrapCommand;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import io.openbpm.bpm.engine.impl.db.entitymanager.OptimisticLockingResult;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.EverLivingJobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyManager;
import io.openbpm.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import java.util.UUID;

public class BootstrapEngineCommand
implements ProcessEngineBootstrapCommand {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final String INSTALLATION_PROPERTY_NAME = "openbpm.installation.id";

    @Override
    public Void execute(CommandContext commandContext) {
        this.initializeInstallationId(commandContext);
        this.checkDeploymentLockExists(commandContext);
        if (this.isHistoryCleanupEnabled(commandContext)) {
            this.checkHistoryCleanupLockExists(commandContext);
            this.createHistoryCleanupJob(commandContext);
        }
        this.updateTelemetryData(commandContext);
        return null;
    }

    protected void createHistoryCleanupJob(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().getManagementService().getTableMetaData("ACT_RU_JOB") != null) {
            commandContext.getDbEntityManager().registerOptimisticLockingListener(new OptimisticLockingListener(){

                @Override
                public Class<? extends DbEntity> getEntityType() {
                    return EverLivingJobEntity.class;
                }

                @Override
                public OptimisticLockingResult failedOperation(DbOperation operation) {
                    return OptimisticLockingResult.IGNORE;
                }
            });
            Context.getProcessEngineConfiguration().getHistoryService().cleanUpHistoryAsync();
        }
    }

    public void checkDeploymentLockExists(CommandContext commandContext) {
        PropertyEntity deploymentLockProperty = commandContext.getPropertyManager().findPropertyById("deployment.lock");
        if (deploymentLockProperty == null) {
            LOG.noDeploymentLockPropertyFound();
        }
    }

    public void checkHistoryCleanupLockExists(CommandContext commandContext) {
        PropertyEntity historyCleanupLockProperty = commandContext.getPropertyManager().findPropertyById("history.cleanup.job.lock");
        if (historyCleanupLockProperty == null) {
            LOG.noHistoryCleanupLockPropertyFound();
        }
    }

    protected boolean isHistoryCleanupEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isHistoryCleanupEnabled();
    }

    public void initializeInstallationId(CommandContext commandContext) {
        this.checkInstallationIdLockExists(commandContext);
        String databaseInstallationId = this.databaseInstallationId(commandContext);
        if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
            this.acquireExclusiveInstallationIdLock(commandContext);
            databaseInstallationId = this.databaseInstallationId(commandContext);
            if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
                LOG.noInstallationIdPropertyFound();
                this.createInstallationProperty(commandContext);
            }
        } else {
            LOG.installationIdPropertyFound(databaseInstallationId);
            commandContext.getProcessEngineConfiguration().setInstallationId(databaseInstallationId);
        }
    }

    protected void createInstallationProperty(CommandContext commandContext) {
        String installationId = UUID.randomUUID().toString();
        PropertyEntity property = new PropertyEntity(INSTALLATION_PROPERTY_NAME, installationId);
        commandContext.getPropertyManager().insert(property);
        LOG.creatingInstallationPropertyInDatabase(property.getValue());
        commandContext.getProcessEngineConfiguration().setInstallationId(installationId);
    }

    protected String databaseInstallationId(CommandContext commandContext) {
        try {
            PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById(INSTALLATION_PROPERTY_NAME);
            return installationIdProperty != null ? installationIdProperty.getValue() : null;
        }
        catch (Exception e) {
            LOG.couldNotSelectInstallationId(e.getMessage());
            return null;
        }
    }

    protected void checkInstallationIdLockExists(CommandContext commandContext) {
        PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById("installationId.lock");
        if (installationIdProperty == null) {
            LOG.noInstallationIdLockPropertyFound();
        }
    }

    protected void updateTelemetryData(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        String installationId = processEngineConfiguration.getInstallationId();
        TelemetryDataImpl telemetryData = processEngineConfiguration.getTelemetryData();
        telemetryData.setInstallation(installationId);
    }

    protected void acquireExclusiveInstallationIdLock(CommandContext commandContext) {
        PropertyManager propertyManager = commandContext.getPropertyManager();
        propertyManager.acquireExclusiveLockForInstallationId();
    }
}

