/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.DeploymentQueryProperty;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.CompareUtil;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.repository.Deployment;
import io.openbpm.bpm.engine.repository.DeploymentQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class DeploymentQueryImpl
extends AbstractQuery<DeploymentQuery, Deployment>
implements DeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;
    protected boolean sourceQueryParamEnabled;
    protected String source;
    protected Date deploymentBefore;
    protected Date deploymentAfter;
    protected boolean isTenantIdSet;
    protected String[] tenantIds;
    protected boolean includeDeploymentsWithoutTenantId;

    public DeploymentQueryImpl() {
    }

    public DeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DeploymentQueryImpl deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("Deployment id", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentName(String deploymentName) {
        EnsureUtil.ensureNotNull("deploymentName", (Object)deploymentName);
        this.name = deploymentName;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("deploymentNameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public DeploymentQuery deploymentSource(String source) {
        this.sourceQueryParamEnabled = true;
        this.source = source;
        return this;
    }

    @Override
    public DeploymentQuery deploymentBefore(Date before) {
        EnsureUtil.ensureNotNull("deploymentBefore", (Object)before);
        this.deploymentBefore = before;
        return this;
    }

    @Override
    public DeploymentQuery deploymentAfter(Date after) {
        EnsureUtil.ensureNotNull("deploymentAfter", (Object)after);
        this.deploymentAfter = after;
        return this;
    }

    @Override
    public DeploymentQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", (Object[])tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DeploymentQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public DeploymentQuery includeDeploymentsWithoutTenantId() {
        this.includeDeploymentsWithoutTenantId = true;
        return this;
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.areNotInAscendingOrder((Comparable[])new Date[]{this.deploymentAfter, this.deploymentBefore});
    }

    @Override
    public DeploymentQuery orderByDeploymentId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public DeploymentQuery orderByDeploymentTime() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    @Override
    public DeploymentQuery orderByDeploymentName() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    @Override
    public DeploymentQuery orderByTenantId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentCountByQueryCriteria(this);
    }

    @Override
    public List<Deployment> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDeploymentManager().findDeploymentsByQueryCriteria(this, page);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public boolean isSourceQueryParamEnabled() {
        return this.sourceQueryParamEnabled;
    }

    public String getSource() {
        return this.source;
    }

    public Date getDeploymentBefore() {
        return this.deploymentBefore;
    }

    public Date getDeploymentAfter() {
        return this.deploymentAfter;
    }
}

