/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.FilterService;
import io.openbpm.bpm.engine.filter.Filter;
import io.openbpm.bpm.engine.filter.FilterQuery;
import io.openbpm.bpm.engine.impl.ServiceImpl;
import io.openbpm.bpm.engine.impl.cmd.CreateFilterCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteFilterCmd;
import io.openbpm.bpm.engine.impl.cmd.ExecuteFilterCountCmd;
import io.openbpm.bpm.engine.impl.cmd.ExecuteFilterListCmd;
import io.openbpm.bpm.engine.impl.cmd.ExecuteFilterListPageCmd;
import io.openbpm.bpm.engine.impl.cmd.ExecuteFilterSingleResultCmd;
import io.openbpm.bpm.engine.impl.cmd.GetFilterCmd;
import io.openbpm.bpm.engine.impl.cmd.SaveFilterCmd;
import io.openbpm.bpm.engine.impl.filter.FilterQueryImpl;
import io.openbpm.bpm.engine.query.Query;
import java.util.List;

public class FilterServiceImpl
extends ServiceImpl
implements FilterService {
    @Override
    public Filter newTaskFilter() {
        return this.commandExecutor.execute(new CreateFilterCmd("Task"));
    }

    @Override
    public Filter newTaskFilter(String filterName) {
        return this.newTaskFilter().setName(filterName);
    }

    @Override
    public FilterQuery createFilterQuery() {
        return new FilterQueryImpl(this.commandExecutor);
    }

    @Override
    public FilterQuery createTaskFilterQuery() {
        return new FilterQueryImpl(this.commandExecutor).filterResourceType("Task");
    }

    @Override
    public Filter saveFilter(Filter filter) {
        return this.commandExecutor.execute(new SaveFilterCmd(filter));
    }

    @Override
    public Filter getFilter(String filterId) {
        return this.commandExecutor.execute(new GetFilterCmd(filterId));
    }

    @Override
    public void deleteFilter(String filterId) {
        this.commandExecutor.execute(new DeleteFilterCmd(filterId));
    }

    @Override
    public <T> List<T> list(String filterId) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListCmd(filterId));
    }

    @Override
    public <T, Q extends Query<?, T>> List<T> list(String filterId, Q extendingQuery) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListCmd(filterId, extendingQuery));
    }

    @Override
    public <T> List<T> listPage(String filterId, int firstResult, int maxResults) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListPageCmd(filterId, firstResult, maxResults));
    }

    @Override
    public <T, Q extends Query<?, T>> List<T> listPage(String filterId, Q extendingQuery, int firstResult, int maxResults) {
        return (List)this.commandExecutor.execute(new ExecuteFilterListPageCmd(filterId, extendingQuery, firstResult, maxResults));
    }

    @Override
    public <T> T singleResult(String filterId) {
        return (T)this.commandExecutor.execute(new ExecuteFilterSingleResultCmd(filterId));
    }

    @Override
    public <T, Q extends Query<?, T>> T singleResult(String filterId, Q extendingQuery) {
        return (T)this.commandExecutor.execute(new ExecuteFilterSingleResultCmd(filterId, extendingQuery));
    }

    @Override
    public Long count(String filterId) {
        return this.commandExecutor.execute(new ExecuteFilterCountCmd(filterId));
    }

    @Override
    public Long count(String filterId, Query<?, ?> extendingQuery) {
        return this.commandExecutor.execute(new ExecuteFilterCountCmd(filterId, extendingQuery));
    }
}

