/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.identity.Group;
import io.openbpm.bpm.engine.identity.GroupQuery;
import io.openbpm.bpm.engine.identity.NativeUserQuery;
import io.openbpm.bpm.engine.identity.PasswordPolicy;
import io.openbpm.bpm.engine.identity.PasswordPolicyResult;
import io.openbpm.bpm.engine.identity.PasswordPolicyRule;
import io.openbpm.bpm.engine.identity.Picture;
import io.openbpm.bpm.engine.identity.Tenant;
import io.openbpm.bpm.engine.identity.TenantQuery;
import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.impl.ServiceImpl;
import io.openbpm.bpm.engine.impl.cmd.CheckPassword;
import io.openbpm.bpm.engine.impl.cmd.CreateGroupCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateGroupQueryCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateNativeUserQueryCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateTenantCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateTenantGroupMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateTenantQueryCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateTenantUserMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateUserCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateUserQueryCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteGroupCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteTenantCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteTenantGroupMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteTenantUserMembershipCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteUserCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteUserInfoCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteUserPictureCmd;
import io.openbpm.bpm.engine.impl.cmd.GetPasswordPolicyCmd;
import io.openbpm.bpm.engine.impl.cmd.GetUserAccountCmd;
import io.openbpm.bpm.engine.impl.cmd.GetUserInfoCmd;
import io.openbpm.bpm.engine.impl.cmd.GetUserInfoKeysCmd;
import io.openbpm.bpm.engine.impl.cmd.GetUserPictureCmd;
import io.openbpm.bpm.engine.impl.cmd.IsIdentityServiceReadOnlyCmd;
import io.openbpm.bpm.engine.impl.cmd.SaveGroupCmd;
import io.openbpm.bpm.engine.impl.cmd.SaveTenantCmd;
import io.openbpm.bpm.engine.impl.cmd.SaveUserCmd;
import io.openbpm.bpm.engine.impl.cmd.SetUserInfoCmd;
import io.openbpm.bpm.engine.impl.cmd.SetUserPictureCmd;
import io.openbpm.bpm.engine.impl.cmd.UnlockUserCmd;
import io.openbpm.bpm.engine.impl.identity.Account;
import io.openbpm.bpm.engine.impl.identity.Authentication;
import io.openbpm.bpm.engine.impl.identity.PasswordPolicyResultImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IdentityServiceImpl
extends ServiceImpl
implements IdentityService {
    private final ThreadLocal<Authentication> currentAuthentication = new ThreadLocal();

    @Override
    public boolean isReadOnly() {
        return this.commandExecutor.execute(new IsIdentityServiceReadOnlyCmd());
    }

    @Override
    public Group newGroup(String groupId) {
        return this.commandExecutor.execute(new CreateGroupCmd(groupId));
    }

    @Override
    public User newUser(String userId) {
        return this.commandExecutor.execute(new CreateUserCmd(userId));
    }

    @Override
    public Tenant newTenant(String tenantId) {
        return this.commandExecutor.execute(new CreateTenantCmd(tenantId));
    }

    @Override
    public void saveGroup(Group group) {
        try {
            this.commandExecutor.execute(new SaveGroupCmd(group));
        }
        catch (ProcessEngineException ex) {
            if (ExceptionUtil.checkConstraintViolationException(ex)) {
                throw new BadUserRequestException("The group already exists", ex);
            }
            throw ex;
        }
    }

    @Override
    public void saveUser(User user) {
        this.saveUser(user, false);
    }

    public void saveUser(User user, boolean skipPasswordPolicy) {
        try {
            this.commandExecutor.execute(new SaveUserCmd(user, skipPasswordPolicy));
        }
        catch (ProcessEngineException ex) {
            if (ExceptionUtil.checkConstraintViolationException(ex)) {
                throw new BadUserRequestException("The user already exists", ex);
            }
            throw ex;
        }
    }

    @Override
    public void saveTenant(Tenant tenant) {
        try {
            this.commandExecutor.execute(new SaveTenantCmd(tenant));
        }
        catch (ProcessEngineException ex) {
            if (ExceptionUtil.checkConstraintViolationException(ex)) {
                throw new BadUserRequestException("The tenant already exists", ex);
            }
            throw ex;
        }
    }

    @Override
    public UserQuery createUserQuery() {
        return this.commandExecutor.execute(new CreateUserQueryCmd());
    }

    @Override
    public NativeUserQuery createNativeUserQuery() {
        return this.commandExecutor.execute(new CreateNativeUserQueryCmd());
    }

    @Override
    public GroupQuery createGroupQuery() {
        return this.commandExecutor.execute(new CreateGroupQueryCmd());
    }

    @Override
    public TenantQuery createTenantQuery() {
        return this.commandExecutor.execute(new CreateTenantQueryCmd());
    }

    @Override
    public void createMembership(String userId, String groupId) {
        this.commandExecutor.execute(new CreateMembershipCmd(userId, groupId));
    }

    @Override
    public void deleteGroup(String groupId) {
        this.commandExecutor.execute(new DeleteGroupCmd(groupId));
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        this.commandExecutor.execute(new DeleteMembershipCmd(userId, groupId));
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        return this.commandExecutor.execute(new CheckPassword(userId, password));
    }

    @Override
    public PasswordPolicyResult checkPasswordAgainstPolicy(String candidatePassword, User user) {
        return this.checkPasswordAgainstPolicy(this.getPasswordPolicy(), candidatePassword, user);
    }

    @Override
    public PasswordPolicyResult checkPasswordAgainstPolicy(String password) {
        return this.checkPasswordAgainstPolicy(this.getPasswordPolicy(), password, null);
    }

    @Override
    public PasswordPolicyResult checkPasswordAgainstPolicy(PasswordPolicy policy, String candidatePassword, User user) {
        EnsureUtil.ensureNotNull("policy", (Object)policy);
        EnsureUtil.ensureNotNull("password", (Object)candidatePassword);
        ArrayList<PasswordPolicyRule> violatedRules = new ArrayList<PasswordPolicyRule>();
        ArrayList<PasswordPolicyRule> fulfilledRules = new ArrayList<PasswordPolicyRule>();
        for (PasswordPolicyRule rule : policy.getRules()) {
            if (rule.execute(candidatePassword, user)) {
                fulfilledRules.add(rule);
                continue;
            }
            violatedRules.add(rule);
        }
        return new PasswordPolicyResultImpl(violatedRules, fulfilledRules);
    }

    @Override
    public PasswordPolicyResult checkPasswordAgainstPolicy(PasswordPolicy policy, String password) {
        return this.checkPasswordAgainstPolicy(policy, password, null);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() {
        return this.commandExecutor.execute(new GetPasswordPolicyCmd());
    }

    @Override
    public void unlockUser(String userId) {
        this.commandExecutor.execute(new UnlockUserCmd(userId));
    }

    @Override
    public void deleteUser(String userId) {
        this.commandExecutor.execute(new DeleteUserCmd(userId));
    }

    @Override
    public void deleteTenant(String tenantId) {
        this.commandExecutor.execute(new DeleteTenantCmd(tenantId));
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        this.commandExecutor.execute(new SetUserPictureCmd(userId, picture));
    }

    @Override
    public Picture getUserPicture(String userId) {
        return this.commandExecutor.execute(new GetUserPictureCmd(userId));
    }

    @Override
    public void deleteUserPicture(String userId) {
        this.commandExecutor.execute(new DeleteUserPictureCmd(userId));
    }

    @Override
    public void setAuthenticatedUserId(String authenticatedUserId) {
        this.setAuthentication(new Authentication(authenticatedUserId, null));
    }

    @Override
    public void setAuthentication(Authentication auth) {
        if (auth == null) {
            this.clearAuthentication();
        } else {
            if (auth.getUserId() != null) {
                EnsureUtil.ensureValidIndividualResourceId("Invalid user id provided", auth.getUserId());
            }
            if (auth.getGroupIds() != null) {
                EnsureUtil.ensureValidIndividualResourceIds("At least one invalid group id provided", auth.getGroupIds());
            }
            if (auth.getTenantIds() != null) {
                EnsureUtil.ensureValidIndividualResourceIds("At least one invalid tenant id provided", auth.getTenantIds());
            }
            this.currentAuthentication.set(auth);
        }
    }

    @Override
    public void setAuthentication(String userId, List<String> groups) {
        this.setAuthentication(new Authentication(userId, groups));
    }

    @Override
    public void setAuthentication(String userId, List<String> groups, List<String> tenantIds) {
        this.setAuthentication(new Authentication(userId, groups, tenantIds));
    }

    @Override
    public void clearAuthentication() {
        this.currentAuthentication.remove();
    }

    @Override
    public Authentication getCurrentAuthentication() {
        return this.currentAuthentication.get();
    }

    @Override
    public String getUserInfo(String userId, String key) {
        return this.commandExecutor.execute(new GetUserInfoCmd(userId, key));
    }

    @Override
    public List<String> getUserInfoKeys(String userId) {
        return this.commandExecutor.execute(new GetUserInfoKeysCmd(userId, "userinfo"));
    }

    @Override
    public List<String> getUserAccountNames(String userId) {
        return this.commandExecutor.execute(new GetUserInfoKeysCmd(userId, "account"));
    }

    @Override
    public void setUserInfo(String userId, String key, String value) {
        this.commandExecutor.execute(new SetUserInfoCmd(userId, key, value));
    }

    @Override
    public void deleteUserInfo(String userId, String key) {
        this.commandExecutor.execute(new DeleteUserInfoCmd(userId, key));
    }

    @Override
    public void deleteUserAccount(String userId, String accountName) {
        this.commandExecutor.execute(new DeleteUserInfoCmd(userId, accountName));
    }

    @Override
    public Account getUserAccount(String userId, String userPassword, String accountName) {
        return this.commandExecutor.execute(new GetUserAccountCmd(userId, userPassword, accountName));
    }

    @Override
    public void setUserAccount(String userId, String userPassword, String accountName, String accountUsername, String accountPassword, Map<String, String> accountDetails) {
        this.commandExecutor.execute(new SetUserInfoCmd(userId, userPassword, accountName, accountUsername, accountPassword, accountDetails));
    }

    @Override
    public void createTenantUserMembership(String tenantId, String userId) {
        this.commandExecutor.execute(new CreateTenantUserMembershipCmd(tenantId, userId));
    }

    @Override
    public void createTenantGroupMembership(String tenantId, String groupId) {
        this.commandExecutor.execute(new CreateTenantGroupMembershipCmd(tenantId, groupId));
    }

    @Override
    public void deleteTenantUserMembership(String tenantId, String userId) {
        this.commandExecutor.execute(new DeleteTenantUserMembershipCmd(tenantId, userId));
    }

    @Override
    public void deleteTenantGroupMembership(String tenantId, String groupId) {
        this.commandExecutor.execute(new DeleteTenantGroupMembershipCmd(tenantId, groupId));
    }
}

