/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.ProcessApplicationRegistration;
import io.openbpm.bpm.engine.ManagementService;
import io.openbpm.bpm.engine.ProcessEngineConfiguration;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.batch.BatchQuery;
import io.openbpm.bpm.engine.batch.BatchStatisticsQuery;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.ActivityStatisticsQueryImpl;
import io.openbpm.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import io.openbpm.bpm.engine.impl.JobDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.JobQueryImpl;
import io.openbpm.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import io.openbpm.bpm.engine.impl.SchemaLogQueryImpl;
import io.openbpm.bpm.engine.impl.ServiceImpl;
import io.openbpm.bpm.engine.impl.TablePageQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchStatisticsQueryImpl;
import io.openbpm.bpm.engine.impl.batch.DeleteBatchCmd;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cmd.ActivateBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteJobCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteMetricsCmd;
import io.openbpm.bpm.engine.impl.cmd.DeletePropertyCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteTaskMetricsCmd;
import io.openbpm.bpm.engine.impl.cmd.GetHistoryLevelCmd;
import io.openbpm.bpm.engine.impl.cmd.GetJobExceptionStacktraceCmd;
import io.openbpm.bpm.engine.impl.cmd.GetProcessApplicationForDeploymentCmd;
import io.openbpm.bpm.engine.impl.cmd.GetPropertiesCmd;
import io.openbpm.bpm.engine.impl.cmd.GetTableCountCmd;
import io.openbpm.bpm.engine.impl.cmd.GetTableMetaDataCmd;
import io.openbpm.bpm.engine.impl.cmd.GetTableNameCmd;
import io.openbpm.bpm.engine.impl.cmd.GetTelemetryDataCmd;
import io.openbpm.bpm.engine.impl.cmd.GetUniqueTaskWorkerCountCmd;
import io.openbpm.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import io.openbpm.bpm.engine.impl.cmd.PurgeDatabaseAndCacheCmd;
import io.openbpm.bpm.engine.impl.cmd.RecalculateJobDuedateCmd;
import io.openbpm.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import io.openbpm.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import io.openbpm.bpm.engine.impl.cmd.ReportDbMetricsCmd;
import io.openbpm.bpm.engine.impl.cmd.SetJobDefinitionPriorityCmd;
import io.openbpm.bpm.engine.impl.cmd.SetJobDuedateCmd;
import io.openbpm.bpm.engine.impl.cmd.SetJobPriorityCmd;
import io.openbpm.bpm.engine.impl.cmd.SetPropertyCmd;
import io.openbpm.bpm.engine.impl.cmd.SuspendBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.TelemetryConfigureCmd;
import io.openbpm.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import io.openbpm.bpm.engine.impl.cmd.UnregisterProcessApplicationCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.sql.DbSqlSession;
import io.openbpm.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import io.openbpm.bpm.engine.impl.diagnostics.DiagnosticsRegistry;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import io.openbpm.bpm.engine.impl.management.PurgeReport;
import io.openbpm.bpm.engine.impl.management.SetJobRetriesBuilderImpl;
import io.openbpm.bpm.engine.impl.management.SetJobRetriesByJobsAsyncBuilderImpl;
import io.openbpm.bpm.engine.impl.management.SetJobRetriesByProcessAsyncBuilderImpl;
import io.openbpm.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.metrics.MetricsQueryImpl;
import io.openbpm.bpm.engine.impl.metrics.MetricsRegistry;
import io.openbpm.bpm.engine.management.ActivityStatisticsQuery;
import io.openbpm.bpm.engine.management.DeploymentStatisticsQuery;
import io.openbpm.bpm.engine.management.JobDefinitionQuery;
import io.openbpm.bpm.engine.management.MetricsQuery;
import io.openbpm.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import io.openbpm.bpm.engine.management.SchemaLogQuery;
import io.openbpm.bpm.engine.management.SetJobRetriesByJobsAsyncBuilder;
import io.openbpm.bpm.engine.management.SetJobRetriesByProcessAsyncBuilder;
import io.openbpm.bpm.engine.management.TableMetaData;
import io.openbpm.bpm.engine.management.TablePageQuery;
import io.openbpm.bpm.engine.management.UpdateJobDefinitionSuspensionStateSelectBuilder;
import io.openbpm.bpm.engine.management.UpdateJobSuspensionStateSelectBuilder;
import io.openbpm.bpm.engine.runtime.JobQuery;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.bpm.engine.telemetry.TelemetryData;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    protected ProcessEngineConfiguration processEngineConfiguration;

    public ManagementServiceImpl(ProcessEngineConfiguration processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public ProcessApplicationRegistration registerProcessApplication(String deploymentId, ProcessApplicationReference reference) {
        return this.commandExecutor.execute(new RegisterProcessApplicationCmd(deploymentId, reference));
    }

    @Override
    public void unregisterProcessApplication(String deploymentId, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentId, removeProcessesFromCache));
    }

    @Override
    public void unregisterProcessApplication(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentIds, removeProcessesFromCache));
    }

    @Override
    public String getProcessApplicationForDeployment(String deploymentId) {
        return this.commandExecutor.execute(new GetProcessApplicationForDeploymentCmd(deploymentId));
    }

    @Override
    public Map<String, Long> getTableCount() {
        return this.commandExecutor.execute(new GetTableCountCmd());
    }

    @Override
    public String getTableName(Class<?> activitiEntityClass) {
        return this.commandExecutor.execute(new GetTableNameCmd(activitiEntityClass));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.commandExecutor.execute(new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        ExecuteJobHelper.executeJob(jobId, this.commandExecutor);
    }

    @Override
    public void deleteJob(String jobId) {
        this.commandExecutor.execute(new DeleteJobCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.setJobRetries(retries).jobId(jobId).execute();
    }

    @Override
    public void setJobRetries(List<String> jobIds, int retries) {
        this.setJobRetries(retries).jobIds(jobIds).execute();
    }

    @Override
    public void setJobRetriesByJobDefinitionId(String jobDefinitionId, int retries) {
        this.setJobRetries(retries).jobDefinitionId(jobDefinitionId).execute();
    }

    @Override
    public SetJobRetriesBuilderImpl setJobRetries(int retries) {
        return new SetJobRetriesBuilderImpl(this.commandExecutor, retries);
    }

    @Override
    public Batch setJobRetriesAsync(List<String> jobIds, int retries) {
        return this.setJobRetriesByJobsAsync(retries).jobIds(jobIds).executeAsync();
    }

    @Override
    public Batch setJobRetriesAsync(JobQuery jobQuery, int retries) {
        return this.setJobRetriesByJobsAsync(retries).jobQuery(jobQuery).executeAsync();
    }

    @Override
    public Batch setJobRetriesAsync(List<String> jobIds, JobQuery jobQuery, int retries) {
        return this.setJobRetriesByJobsAsync(retries).jobIds(jobIds).jobQuery(jobQuery).executeAsync();
    }

    @Override
    public Batch setJobRetriesAsync(List<String> processInstanceIds, ProcessInstanceQuery query, int retries) {
        return this.setJobRetriesByProcessAsync(retries).processInstanceIds(processInstanceIds).processInstanceQuery(query).executeAsync();
    }

    @Override
    public Batch setJobRetriesAsync(List<String> processInstanceIds, ProcessInstanceQuery query, HistoricProcessInstanceQuery historicProcessInstanceQuery, int retries) {
        return this.setJobRetriesByProcessAsync(retries).processInstanceIds(processInstanceIds).processInstanceQuery(query).historicProcessInstanceQuery(historicProcessInstanceQuery).executeAsync();
    }

    @Override
    public SetJobRetriesByJobsAsyncBuilder setJobRetriesByJobsAsync(int retries) {
        return new SetJobRetriesByJobsAsyncBuilderImpl(this.commandExecutor, retries);
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder setJobRetriesByProcessAsync(int retries) {
        return new SetJobRetriesByProcessAsyncBuilderImpl(this.commandExecutor, retries);
    }

    @Override
    public void setJobDuedate(String jobId, Date newDuedate) {
        this.setJobDuedate(jobId, newDuedate, false);
    }

    @Override
    public void setJobDuedate(String jobId, Date newDuedate, boolean cascade) {
        this.commandExecutor.execute(new SetJobDuedateCmd(jobId, newDuedate, cascade));
    }

    @Override
    public void recalculateJobDuedate(String jobId, boolean creationDateBased) {
        this.commandExecutor.execute(new RecalculateJobDuedateCmd(jobId, creationDateBased));
    }

    @Override
    public void setJobPriority(String jobId, long priority) {
        this.commandExecutor.execute(new SetJobPriorityCmd(jobId, priority));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public JobDefinitionQuery createJobDefinitionQuery() {
        return new JobDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return this.commandExecutor.execute(new GetJobExceptionStacktraceCmd(jobId));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.commandExecutor.execute(new GetPropertiesCmd());
    }

    @Override
    public void setProperty(String name, String value) {
        this.commandExecutor.execute(new SetPropertyCmd(name, value));
    }

    @Override
    public void deleteProperty(String name) {
        this.commandExecutor.execute(new DeletePropertyCmd(name));
    }

    @Override
    public String databaseSchemaUpgrade(Connection connection, String catalog, String schema) {
        return this.commandExecutor.execute(new DbSchemaUpgradeCmd(connection, catalog, schema));
    }

    public PurgeReport purge() {
        return this.commandExecutor.execute(new PurgeDatabaseAndCacheCmd());
    }

    @Override
    public ProcessDefinitionStatisticsQuery createProcessDefinitionStatisticsQuery() {
        return new ProcessDefinitionStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public ActivityStatisticsQuery createActivityStatisticsQuery(String processDefinitionId) {
        return new ActivityStatisticsQueryImpl(processDefinitionId, this.commandExecutor);
    }

    @Override
    public DeploymentStatisticsQuery createDeploymentStatisticsQuery() {
        return new DeploymentStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public Set<String> getRegisteredDeployments() {
        return this.commandExecutor.execute(new GetRegisteredDeploymentsCmd());
    }

    @Override
    public void registerDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new RegisterDeploymentCmd(deploymentId));
    }

    @Override
    public void unregisterDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new UnregisterDeploymentCmd(deploymentId));
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).activate();
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).suspend();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public UpdateJobDefinitionSuspensionStateSelectBuilder updateJobDefinitionSuspensionState() {
        return new UpdateJobDefinitionSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public void activateJobById(String jobId) {
        this.updateJobSuspensionState().byJobId(jobId).activate();
    }

    @Override
    public void activateJobByProcessInstanceId(String processInstanceId) {
        this.updateJobSuspensionState().byProcessInstanceId(processInstanceId).activate();
    }

    @Override
    public void activateJobByJobDefinitionId(String jobDefinitionId) {
        this.updateJobSuspensionState().byJobDefinitionId(jobDefinitionId).activate();
    }

    @Override
    public void activateJobByProcessDefinitionId(String processDefinitionId) {
        this.updateJobSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateJobByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void suspendJobById(String jobId) {
        this.updateJobSuspensionState().byJobId(jobId).suspend();
    }

    @Override
    public void suspendJobByJobDefinitionId(String jobDefinitionId) {
        this.updateJobSuspensionState().byJobDefinitionId(jobDefinitionId).suspend();
    }

    @Override
    public void suspendJobByProcessInstanceId(String processInstanceId) {
        this.updateJobSuspensionState().byProcessInstanceId(processInstanceId).suspend();
    }

    @Override
    public void suspendJobByProcessDefinitionId(String processDefinitionId) {
        this.updateJobSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendJobByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public UpdateJobSuspensionStateSelectBuilder updateJobSuspensionState() {
        return new UpdateJobSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public int getHistoryLevel() {
        return this.commandExecutor.execute(new GetHistoryLevelCmd());
    }

    @Override
    public MetricsQuery createMetricsQuery() {
        return new MetricsQueryImpl(this.commandExecutor);
    }

    @Override
    public void deleteMetrics(Date timestamp) {
        this.commandExecutor.execute(new DeleteMetricsCmd(timestamp, null));
    }

    @Override
    public void deleteMetrics(Date timestamp, String reporter) {
        this.commandExecutor.execute(new DeleteMetricsCmd(timestamp, reporter));
    }

    @Override
    public void reportDbMetricsNow() {
        this.commandExecutor.execute(new ReportDbMetricsCmd());
    }

    @Override
    public long getUniqueTaskWorkerCount(Date startTime, Date endTime) {
        return this.commandExecutor.execute(new GetUniqueTaskWorkerCountCmd(startTime, endTime));
    }

    @Override
    public void deleteTaskMetrics(Date timestamp) {
        this.commandExecutor.execute(new DeleteTaskMetricsCmd(timestamp));
    }

    @Override
    public void setOverridingJobPriorityForJobDefinition(String jobDefinitionId, long priority) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, priority, false));
    }

    @Override
    public void setOverridingJobPriorityForJobDefinition(String jobDefinitionId, long priority, boolean cascade) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, priority, true));
    }

    @Override
    public void clearOverridingJobPriorityForJobDefinition(String jobDefinitionId) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, null, false));
    }

    @Override
    public BatchQuery createBatchQuery() {
        return new BatchQueryImpl(this.commandExecutor);
    }

    @Override
    public void deleteBatch(String batchId, boolean cascade) {
        this.commandExecutor.execute(new DeleteBatchCmd(batchId, cascade));
    }

    @Override
    public void suspendBatchById(String batchId) {
        this.commandExecutor.execute(new SuspendBatchCmd(batchId));
    }

    @Override
    public void activateBatchById(String batchId) {
        this.commandExecutor.execute(new ActivateBatchCmd(batchId));
    }

    @Override
    public BatchStatisticsQuery createBatchStatisticsQuery() {
        return new BatchStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public SchemaLogQuery createSchemaLogQuery() {
        return new SchemaLogQueryImpl(this.commandExecutor);
    }

    @Override
    @Deprecated(forRemoval=true, since="1.0")
    public void toggleTelemetry(boolean enabled) {
        this.commandExecutor.execute(new TelemetryConfigureCmd(enabled));
    }

    @Override
    @Deprecated(forRemoval=true, since="1.0")
    public Boolean isTelemetryEnabled() {
        return this.commandExecutor.execute(new IsTelemetryEnabledCmd());
    }

    @Override
    public TelemetryData getTelemetryData() {
        return this.commandExecutor.execute(new GetTelemetryDataCmd());
    }

    public boolean addWebappToTelemetry(String webapp) {
        DiagnosticsRegistry telemetryRegistry = ((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getDiagnosticsRegistry();
        if (telemetryRegistry != null) {
            telemetryRegistry.addWebapp(webapp);
            return true;
        }
        return false;
    }

    public void addApplicationServerInfoToTelemetry(String appServerInfo) {
        DiagnosticsRegistry telemetryRegistry = ((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getDiagnosticsRegistry();
        if (telemetryRegistry != null) {
            telemetryRegistry.setApplicationServer(appServerInfo);
        }
    }

    public void clearDiagnosticsData() {
        MetricsRegistry metricsRegistry;
        DiagnosticsRegistry diagnosticsRegistry = ((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getDiagnosticsRegistry();
        if (diagnosticsRegistry != null) {
            diagnosticsRegistry.clear();
        }
        if ((metricsRegistry = ((ProcessEngineConfigurationImpl)this.processEngineConfiguration).getMetricsRegistry()) != null) {
            metricsRegistry.clearDiagnosticsMetrics();
        }
        this.deleteMetrics(null);
    }

    protected class DbSchemaUpgradeCmd
    implements Command<String> {
        protected Connection connection;
        protected String catalog;
        protected String schema;

        public DbSchemaUpgradeCmd(Connection connection, String catalog, String schema) {
            this.connection = connection;
            this.catalog = catalog;
            this.schema = schema;
        }

        @Override
        public String execute(CommandContext commandContext) {
            commandContext.getAuthorizationManager().checkOperatonAdmin();
            DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
            DbSqlSession dbSqlSession = dbSqlSessionFactory.openSession(this.connection, this.catalog, this.schema);
            commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
            dbSqlSession.dbSchemaUpdate();
            return "";
        }
    }

    protected class GetRegisteredDeploymentsCmd
    implements Command<Set<String>> {
        protected GetRegisteredDeploymentsCmd() {
        }

        @Override
        public Set<String> execute(CommandContext commandContext) {
            commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkReadRegisteredDeployments);
            Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
            return new HashSet<String>(registeredDeployments);
        }
    }
}

