/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.cmd.batch.CorrelateAllMessageBatchCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.MessageCorrelationAsyncBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.List;
import java.util.Map;

public class MessageCorrelationAsyncBuilderImpl
implements MessageCorrelationAsyncBuilder {
    protected CommandExecutor commandExecutor;
    protected String messageName;
    protected Map<String, Object> payloadProcessInstanceVariables;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public MessageCorrelationAsyncBuilderImpl(CommandExecutor commandExecutor, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    private MessageCorrelationAsyncBuilderImpl(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public MessageCorrelationAsyncBuilder processInstanceIds(List<String> ids) {
        EnsureUtil.ensureNotNull("processInstanceIds", ids);
        this.processInstanceIds = ids;
        return this;
    }

    @Override
    public MessageCorrelationAsyncBuilder processInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        EnsureUtil.ensureNotNull("processInstanceQuery", (Object)processInstanceQuery);
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Override
    public MessageCorrelationAsyncBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery historicProcessInstanceQuery) {
        EnsureUtil.ensureNotNull("historicProcessInstanceQuery", (Object)historicProcessInstanceQuery);
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Override
    public MessageCorrelationAsyncBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesInitialized();
        this.payloadProcessInstanceVariables.put(variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationAsyncBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesInitialized();
            this.payloadProcessInstanceVariables.putAll(variables);
        }
        return this;
    }

    protected void ensurePayloadProcessInstanceVariablesInitialized() {
        if (this.payloadProcessInstanceVariables == null) {
            this.payloadProcessInstanceVariables = new VariableMapImpl();
        }
    }

    @Override
    public Batch correlateAllAsync() {
        return this.commandExecutor.execute(new CorrelateAllMessageBatchCmd(this));
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public HistoricProcessInstanceQuery getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public Map<String, Object> getPayloadProcessInstanceVariables() {
        return this.payloadProcessInstanceVariables;
    }
}

