/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.cmd.CorrelateAllMessageCmd;
import io.openbpm.bpm.engine.impl.cmd.CorrelateMessageCmd;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.MessageCorrelationBuilder;
import io.openbpm.bpm.engine.runtime.MessageCorrelationResult;
import io.openbpm.bpm.engine.runtime.MessageCorrelationResultWithVariables;
import io.openbpm.bpm.engine.runtime.ProcessInstance;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MessageCorrelationBuilderImpl
implements MessageCorrelationBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected boolean isExclusiveCorrelation;
    protected String messageName;
    protected String businessKey;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected VariableMap correlationProcessInstanceVariables;
    protected VariableMap correlationLocalVariables;
    protected VariableMap payloadProcessInstanceVariables;
    protected VariableMap payloadProcessInstanceVariablesLocal;
    protected VariableMap payloadProcessInstanceVariablesToTriggeredScope;
    protected String tenantId;
    protected boolean isTenantIdSet;
    protected boolean startMessagesOnly;
    protected boolean executionsOnly;

    public MessageCorrelationBuilderImpl(CommandExecutor commandExecutor, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public MessageCorrelationBuilderImpl(CommandContext commandContext, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandContext", (Object)commandContext);
        this.commandContext = commandContext;
    }

    private MessageCorrelationBuilderImpl(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public MessageCorrelationBuilder processInstanceBusinessKey(String businessKey) {
        EnsureUtil.ensureNotNull("businessKey", (Object)businessKey);
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceVariableEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensureCorrelationProcessInstanceVariablesInitialized();
        this.correlationProcessInstanceVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceVariablesEqual(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull("variables", variables);
        this.ensureCorrelationProcessInstanceVariablesInitialized();
        this.correlationProcessInstanceVariables.putAll(variables);
        return this;
    }

    @Override
    public MessageCorrelationBuilder localVariableEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensureCorrelationLocalVariablesInitialized();
        this.correlationLocalVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder localVariablesEqual(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull("variables", variables);
        this.ensureCorrelationLocalVariablesInitialized();
        this.correlationLocalVariables.putAll(variables);
        return this;
    }

    protected void ensureCorrelationProcessInstanceVariablesInitialized() {
        if (this.correlationProcessInstanceVariables == null) {
            this.correlationProcessInstanceVariables = new VariableMapImpl();
        }
    }

    protected void ensureCorrelationLocalVariablesInitialized() {
        if (this.correlationLocalVariables == null) {
            this.correlationLocalVariables = new VariableMapImpl();
        }
    }

    @Override
    public MessageCorrelationBuilder processInstanceId(String id) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)id);
        this.processInstanceId = id;
        return this;
    }

    @Override
    public MessageCorrelationBuilder processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesInitialized();
        this.payloadProcessInstanceVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariableLocal(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesLocalInitialized();
        this.payloadProcessInstanceVariablesLocal.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariableToTriggeredScope(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesToTriggeredScopeInitialized();
        this.payloadProcessInstanceVariablesToTriggeredScope.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesInitialized();
            this.payloadProcessInstanceVariables.putAll(variables);
        }
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariablesLocal(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesLocalInitialized();
            this.payloadProcessInstanceVariablesLocal.putAll(variables);
        }
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariablesToTriggeredScope(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesToTriggeredScopeInitialized();
            this.payloadProcessInstanceVariablesToTriggeredScope.putAll(variables);
        }
        return this;
    }

    protected void ensurePayloadProcessInstanceVariablesInitialized() {
        if (this.payloadProcessInstanceVariables == null) {
            this.payloadProcessInstanceVariables = new VariableMapImpl();
        }
    }

    protected void ensurePayloadProcessInstanceVariablesLocalInitialized() {
        if (this.payloadProcessInstanceVariablesLocal == null) {
            this.payloadProcessInstanceVariablesLocal = new VariableMapImpl();
        }
    }

    protected void ensurePayloadProcessInstanceVariablesToTriggeredScopeInitialized() {
        if (this.payloadProcessInstanceVariablesToTriggeredScope == null) {
            this.payloadProcessInstanceVariablesToTriggeredScope = new VariableMapImpl();
        }
    }

    @Override
    public MessageCorrelationBuilder tenantId(String tenantId) {
        EnsureUtil.ensureNotNull("The tenant-id cannot be null. Use 'withoutTenantId()' if you want to correlate the message to a process definition or an execution which has no tenant-id.", "tenantId", (Object)tenantId);
        this.isTenantIdSet = true;
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public MessageCorrelationBuilder withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantId = null;
        return this;
    }

    @Override
    public MessageCorrelationBuilder startMessageOnly() {
        EnsureUtil.ensureFalse("Either startMessageOnly or executionsOnly can be set", this.executionsOnly);
        this.startMessagesOnly = true;
        return this;
    }

    public MessageCorrelationBuilder executionsOnly() {
        EnsureUtil.ensureFalse("Either startMessageOnly or executionsOnly can be set", this.startMessagesOnly);
        this.executionsOnly = true;
        return this;
    }

    @Override
    public void correlate() {
        this.correlateWithResult();
    }

    @Override
    public MessageCorrelationResult correlateWithResult() {
        if (this.startMessagesOnly) {
            this.ensureCorrelationVariablesNotSet();
            this.ensureProcessDefinitionAndTenantIdNotSet();
        } else {
            this.ensureProcessDefinitionIdNotSet();
            this.ensureProcessInstanceAndTenantIdNotSet();
        }
        return this.execute(new CorrelateMessageCmd(this, false, false, this.startMessagesOnly));
    }

    @Override
    public MessageCorrelationResultWithVariables correlateWithResultAndVariables(boolean deserializeValues) {
        if (this.startMessagesOnly) {
            this.ensureCorrelationVariablesNotSet();
            this.ensureProcessDefinitionAndTenantIdNotSet();
        } else {
            this.ensureProcessDefinitionIdNotSet();
            this.ensureProcessInstanceAndTenantIdNotSet();
        }
        return this.execute(new CorrelateMessageCmd(this, true, deserializeValues, this.startMessagesOnly));
    }

    @Override
    public void correlateExclusively() {
        this.isExclusiveCorrelation = true;
        this.correlate();
    }

    @Override
    public void correlateAll() {
        this.correlateAllWithResult();
    }

    @Override
    public List<MessageCorrelationResult> correlateAllWithResult() {
        if (this.startMessagesOnly) {
            this.ensureCorrelationVariablesNotSet();
            this.ensureProcessDefinitionAndTenantIdNotSet();
            MessageCorrelationResult result = this.execute(new CorrelateMessageCmd(this, false, false, this.startMessagesOnly));
            return Arrays.asList(result);
        }
        this.ensureProcessDefinitionIdNotSet();
        this.ensureProcessInstanceAndTenantIdNotSet();
        return this.execute(new CorrelateAllMessageCmd(this, false, false));
    }

    @Override
    public List<MessageCorrelationResultWithVariables> correlateAllWithResultAndVariables(boolean deserializeValues) {
        if (this.startMessagesOnly) {
            this.ensureCorrelationVariablesNotSet();
            this.ensureProcessDefinitionAndTenantIdNotSet();
            MessageCorrelationResultWithVariables result = this.execute(new CorrelateMessageCmd(this, true, deserializeValues, this.startMessagesOnly));
            return Arrays.asList(result);
        }
        this.ensureProcessDefinitionIdNotSet();
        this.ensureProcessInstanceAndTenantIdNotSet();
        return this.execute(new CorrelateAllMessageCmd(this, true, deserializeValues));
    }

    @Override
    public ProcessInstance correlateStartMessage() {
        this.startMessageOnly();
        MessageCorrelationResult result = this.correlateWithResult();
        return result.getProcessInstance();
    }

    protected void ensureProcessDefinitionIdNotSet() {
        if (this.processDefinitionId != null) {
            throw LOG.exceptionCorrelateMessageWithProcessDefinitionId();
        }
    }

    protected void ensureProcessInstanceAndTenantIdNotSet() {
        if (this.processInstanceId != null && this.isTenantIdSet) {
            throw LOG.exceptionCorrelateMessageWithProcessInstanceAndTenantId();
        }
    }

    protected void ensureCorrelationVariablesNotSet() {
        if (this.correlationProcessInstanceVariables != null || this.correlationLocalVariables != null) {
            throw LOG.exceptionCorrelateStartMessageWithCorrelationVariables();
        }
    }

    protected void ensureProcessDefinitionAndTenantIdNotSet() {
        if (this.processDefinitionId != null && this.isTenantIdSet) {
            throw LOG.exceptionCorrelateMessageWithProcessDefinitionAndTenantId();
        }
    }

    protected <T> T execute(Command<T> command) {
        if (this.commandExecutor != null) {
            return this.commandExecutor.execute(command);
        }
        return command.execute(this.commandContext);
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public Map<String, Object> getCorrelationProcessInstanceVariables() {
        return this.correlationProcessInstanceVariables;
    }

    public Map<String, Object> getCorrelationLocalVariables() {
        return this.correlationLocalVariables;
    }

    public Map<String, Object> getPayloadProcessInstanceVariables() {
        return this.payloadProcessInstanceVariables;
    }

    public VariableMap getPayloadProcessInstanceVariablesLocal() {
        return this.payloadProcessInstanceVariablesLocal;
    }

    public VariableMap getPayloadProcessInstanceVariablesToTriggeredScope() {
        return this.payloadProcessInstanceVariablesToTriggeredScope;
    }

    public boolean isExclusiveCorrelation() {
        return this.isExclusiveCorrelation;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    public boolean isExecutionsOnly() {
        return this.executionsOnly;
    }
}

