/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.JobQueryImpl;
import io.openbpm.bpm.engine.impl.ProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.batch.BatchElementConfiguration;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetJobsRetriesBatchCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class SetJobsRetriesByProcessBatchCmd
extends AbstractSetJobsRetriesBatchCmd {
    protected final List<String> processInstanceIds;
    protected final ProcessInstanceQuery query;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public SetJobsRetriesByProcessBatchCmd(List<String> processInstanceIds, ProcessInstanceQuery query, HistoricProcessInstanceQuery historicProcessInstanceQuery, int retries, Date dueDate, boolean isDueDateSet) {
        this.processInstanceIds = processInstanceIds;
        this.query = query;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.retries = retries;
        this.dueDate = dueDate;
        this.isDueDateSet = isDueDateSet;
    }

    @Override
    protected BatchElementConfiguration collectJobIds(CommandContext commandContext) {
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        if (this.query != null) {
            collectedProcessInstanceIds.addAll(((ProcessInstanceQueryImpl)this.query).listIds());
        }
        if (this.historicProcessInstanceQuery != null) {
            List<String> ids = ((HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery).listIds();
            collectedProcessInstanceIds.addAll(ids);
        }
        if (this.processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(this.processInstanceIds);
        }
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(collectedProcessInstanceIds)) {
            JobQueryImpl jobQuery = new JobQueryImpl();
            jobQuery.processInstanceIds(collectedProcessInstanceIds);
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(jobQuery::listDeploymentIdMappings));
        }
        return elementConfiguration;
    }
}

