/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch;

import io.openbpm.bpm.engine.impl.batch.BatchEntity;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class BatchMonitorJobHandler
implements JobHandler<BatchMonitorJobConfiguration> {
    public static final String TYPE = "batch-monitor-job";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(BatchMonitorJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String batchId = configuration.getBatchId();
        BatchEntity batch = commandContext.getBatchManager().findBatchById(configuration.getBatchId());
        EnsureUtil.ensureNotNull("Batch with id '" + batchId + "' cannot be found", "batch", (Object)batch);
        boolean completed = batch.isCompleted();
        if (!completed) {
            batch.createMonitorJob(true);
        } else {
            batch.delete(false, false);
        }
    }

    @Override
    public BatchMonitorJobConfiguration newConfiguration(String canonicalString) {
        return new BatchMonitorJobConfiguration(canonicalString);
    }

    public static class BatchMonitorJobConfiguration
    implements JobHandlerConfiguration {
        protected String batchId;

        public BatchMonitorJobConfiguration(String batchId) {
            this.batchId = batchId;
        }

        public String getBatchId() {
            return this.batchId;
        }

        @Override
        public String toCanonicalString() {
            return this.batchId;
        }
    }
}

