/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.batch.BatchQuery;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.BatchQueryProperty;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.persistence.entity.SuspensionState;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class BatchQueryImpl
extends AbstractQuery<BatchQuery, Batch>
implements BatchQuery {
    private static final long serialVersionUID = 1L;
    protected String batchId;
    protected String type;
    protected boolean isTenantIdSet;
    protected String[] tenantIds;
    protected SuspensionState suspensionState;

    public BatchQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public BatchQuery batchId(String batchId) {
        EnsureUtil.ensureNotNull("Batch id", (Object)batchId);
        this.batchId = batchId;
        return this;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public BatchQuery type(String type) {
        EnsureUtil.ensureNotNull("Type", (Object)type);
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BatchQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", (Object[])tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    @Override
    public BatchQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public BatchQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public BatchQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public BatchQuery orderById() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.ID);
    }

    @Override
    public BatchQuery orderByTenantId() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchCountByQueryCriteria(this);
    }

    @Override
    public List<Batch> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getBatchManager().findBatchesByQueryCriteria(this, page);
    }
}

