/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch.message;

import io.openbpm.bpm.engine.impl.MessageCorrelationBuilderImpl;
import io.openbpm.bpm.engine.impl.batch.AbstractBatchJobHandler;
import io.openbpm.bpm.engine.impl.batch.BatchJobContext;
import io.openbpm.bpm.engine.impl.batch.BatchJobDeclaration;
import io.openbpm.bpm.engine.impl.batch.message.MessageCorrelationBatchConfiguration;
import io.openbpm.bpm.engine.impl.cmd.CorrelateAllMessageCmd;
import io.openbpm.bpm.engine.impl.core.variable.VariableUtil;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobDeclaration;
import io.openbpm.bpm.engine.impl.json.MessageCorrelationBatchConfigurationJsonConverter;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.MessageEntity;
import io.openbpm.bpm.engine.runtime.MessageCorrelationBuilder;
import io.openbpm.bpm.engine.variable.impl.VariableMapImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageCorrelationBatchJobHandler
extends AbstractBatchJobHandler<MessageCorrelationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("correlate-message");

    @Override
    public String getType() {
        return "correlate-message";
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    protected MessageCorrelationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return MessageCorrelationBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    protected MessageCorrelationBatchConfiguration createJobConfiguration(MessageCorrelationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new MessageCorrelationBatchConfiguration(processIdsForJob, configuration.getMessageName(), configuration.getBatchId());
    }

    @Override
    protected void postProcessJob(MessageCorrelationBatchConfiguration configuration, JobEntity job, MessageCorrelationBatchConfiguration jobConfiguration) {
        if (jobConfiguration.getIds() != null && jobConfiguration.getIds().size() == 1) {
            job.setProcessInstanceId(jobConfiguration.getIds().get(0));
        }
    }

    @Override
    public void executeHandler(MessageCorrelationBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String batchId = batchConfiguration.getBatchId();
        MessageCorrelationBuilderImpl correlationBuilder = new MessageCorrelationBuilderImpl(commandContext, batchConfiguration.getMessageName());
        correlationBuilder.executionsOnly();
        this.setVariables(batchId, correlationBuilder, commandContext);
        for (String id : batchConfiguration.getIds()) {
            correlationBuilder.processInstanceId(id);
            commandContext.executeWithOperationLogPrevented(new CorrelateAllMessageCmd(correlationBuilder, false, false));
        }
    }

    protected void setVariables(String batchId, MessageCorrelationBuilder correlationBuilder, CommandContext commandContext) {
        Map<String, ?> variables = null;
        if (batchId != null && (variables = VariableUtil.findBatchVariablesSerialized(batchId, commandContext)) != null) {
            correlationBuilder.setVariables((Map<String, Object>)new VariableMapImpl(new HashMap(variables)));
        }
    }
}

