/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch.removaltime;

import io.openbpm.bpm.engine.impl.batch.AbstractBatchJobHandler;
import io.openbpm.bpm.engine.impl.batch.BatchJobContext;
import io.openbpm.bpm.engine.impl.batch.BatchJobDeclaration;
import io.openbpm.bpm.engine.impl.batch.history.HistoricBatchEntity;
import io.openbpm.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import io.openbpm.bpm.engine.impl.batch.removaltime.SetRemovalTimeJsonConverter;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobDeclaration;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.MessageEntity;
import java.util.Date;
import java.util.List;

public class BatchSetRemovalTimeJobHandler
extends AbstractBatchJobHandler<SetRemovalTimeBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("batch-set-removal-time");

    @Override
    public void executeHandler(SetRemovalTimeBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        for (String instanceId : batchConfiguration.getIds()) {
            Date removalTime;
            HistoricBatchEntity instance = this.findBatchById(instanceId, commandContext);
            if (instance == null || (removalTime = this.getOrCalculateRemovalTime(batchConfiguration, instance, commandContext)) == instance.getRemovalTime()) continue;
            this.addRemovalTime(instanceId, removalTime, commandContext);
        }
    }

    protected Date getOrCalculateRemovalTime(SetRemovalTimeBatchConfiguration batchConfiguration, HistoricBatchEntity instance, CommandContext commandContext) {
        if (batchConfiguration.hasRemovalTime()) {
            return batchConfiguration.getRemovalTime();
        }
        if (this.hasBaseTime(instance, commandContext)) {
            return this.calculateRemovalTime(instance, commandContext);
        }
        return null;
    }

    protected void addRemovalTime(String instanceId, Date removalTime, CommandContext commandContext) {
        commandContext.getHistoricBatchManager().addRemovalTimeById(instanceId, removalTime);
    }

    protected boolean hasBaseTime(HistoricBatchEntity instance, CommandContext commandContext) {
        return this.isStrategyStart(commandContext) || this.isStrategyEnd(commandContext) && this.isEnded(instance);
    }

    protected boolean isEnded(HistoricBatchEntity instance) {
        return instance.getEndTime() != null;
    }

    protected boolean isStrategyStart(CommandContext commandContext) {
        return "start".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean isStrategyEnd(CommandContext commandContext) {
        return "end".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected String getHistoryRemovalTimeStrategy(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected boolean isDmnEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isDmnEnabled();
    }

    protected Date calculateRemovalTime(HistoricBatchEntity batch, CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(batch);
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }

    protected HistoricBatchEntity findBatchById(String instanceId, CommandContext commandContext) {
        return commandContext.getHistoricBatchManager().findHistoricBatchById(instanceId);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected SetRemovalTimeBatchConfiguration createJobConfiguration(SetRemovalTimeBatchConfiguration configuration, List<String> batchIds) {
        return new SetRemovalTimeBatchConfiguration(batchIds).setRemovalTime(configuration.getRemovalTime()).setHasRemovalTime(configuration.hasRemovalTime());
    }

    protected SetRemovalTimeJsonConverter getJsonConverterInstance() {
        return SetRemovalTimeJsonConverter.INSTANCE;
    }

    @Override
    public String getType() {
        return "batch-set-removal-time";
    }
}

