/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch.update;

import io.openbpm.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateBatchConfiguration;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import java.util.List;
import openbpmjar.impl.com.google.gson.JsonObject;

public class UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter
extends AbstractBatchConfigurationObjectConverter<UpdateProcessInstancesSuspendStateBatchConfiguration> {
    public static final UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter INSTANCE = new UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter();
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String PROCESS_INSTANCE_ID_MAPPINGS = "processInstanceIdMappings";
    public static final String SUSPENDING = "suspended";

    @Override
    public JsonObject writeConfiguration(UpdateProcessInstancesSuspendStateBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addListField(json, PROCESS_INSTANCE_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addField(json, SUSPENDING, configuration.getSuspended());
        return json;
    }

    @Override
    public UpdateProcessInstancesSuspendStateBatchConfiguration readConfiguration(JsonObject json) {
        return new UpdateProcessInstancesSuspendStateBatchConfiguration(this.readProcessInstanceIds(json), this.readMappings(json), JsonUtil.getBoolean(json, SUSPENDING));
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }

    protected DeploymentMappings readMappings(JsonObject jsonObject) {
        return JsonUtil.asList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

