/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class CancelEndEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected PvmActivity cancelBoundaryEvent;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        EnsureUtil.ensureNotNull("Could not find cancel boundary event for cancel end event " + execution.getActivity(), "cancelBoundaryEvent", (Object)this.cancelBoundaryEvent);
        List<EventSubscriptionEntity> compensateEventSubscriptions = CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
        if (compensateEventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            CompensationUtil.throwCompensationEvent(compensateEventSubscriptions, execution, false);
        }
    }

    @Override
    public void doLeave(ActivityExecution execution) {
        ScopeImpl eventScope = (ScopeImpl)this.cancelBoundaryEvent.getEventScope();
        ActivityExecution boundaryEventScopeExecution = execution.findExecutionForFlowScope(eventScope);
        boundaryEventScopeExecution.executeActivity(this.cancelBoundaryEvent);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!execution.hasChildren()) {
            this.leave(execution);
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }

    public void setCancelBoundaryEvent(PvmActivity cancelBoundaryEvent) {
        this.cancelBoundaryEvent = cancelBoundaryEvent;
    }

    public PvmActivity getCancelBoundaryEvent() {
        return this.cancelBoundaryEvent;
    }
}

