/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import java.util.List;

public class CompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected final CompensateEventDefinition compensateEventDefinition;

    public CompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        List<EventSubscriptionEntity> eventSubscriptions = this.collectEventSubscriptions(execution);
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            CompensationUtil.throwCompensationEvent(eventSubscriptions, execution, false);
        }
    }

    protected List<EventSubscriptionEntity> collectEventSubscriptions(ActivityExecution execution) {
        String activityRef = this.compensateEventDefinition.getActivityRef();
        if (activityRef != null) {
            return CompensationUtil.collectCompensateEventSubscriptionsForActivity(execution, activityRef);
        }
        return CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (((PvmExecutionImpl)execution).getNonEventScopeExecutions().isEmpty()) {
            this.leave(execution);
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }
}

