/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.variable.value.IntegerValue;
import java.util.Collection;
import java.util.Iterator;

public abstract class MultiInstanceActivityBehavior
extends AbstractBpmnActivityBehavior
implements CompositeActivityBehavior,
ModificationObserverBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    public static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    public static final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    public static final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    public static final String LOOP_COUNTER = "loopCounter";
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances == 0) {
            this.leave(execution);
        } else {
            if (nrOfInstances < 0) {
                throw LOG.invalidAmountException("instances", nrOfInstances);
            }
            this.createInstances(execution, nrOfInstances);
        }
    }

    protected void performInstance(ActivityExecution execution, PvmActivity activity, int loopCounter, Collection<?> collection) {
        this.setLoopVariable(execution, LOOP_COUNTER, loopCounter);
        this.evaluateCollectionVariable(execution, collection, loopCounter);
        execution.setEnded(false);
        execution.setActive(true);
        execution.executeActivity(activity);
    }

    protected void evaluateCollectionVariable(ActivityExecution execution, Collection<?> collection, int loopCounter) {
        if (this.usesCollection() && this.collectionElementVariable != null && collection != null) {
            Object value = this.getElementAtIndex(loopCounter, collection);
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
    }

    protected Collection<?> evaluateCollection(ActivityExecution execution) {
        Collection collection = null;
        if (this.usesCollection() && this.collectionElementVariable != null) {
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue(execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
        }
        return collection;
    }

    protected abstract void createInstances(ActivityExecution var1, int var2) throws Exception;

    protected int resolveNrOfInstances(ActivityExecution execution) {
        int nrOfInstances = -1;
        if (this.loopCardinalityExpression != null) {
            nrOfInstances = this.resolveLoopCardinality(execution);
        } else if (this.collectionExpression != null) {
            Object obj = this.collectionExpression.getValue(execution);
            if (!(obj instanceof Collection)) {
                throw LOG.unresolvableExpressionException(this.collectionExpression.getExpressionText(), "Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else if (this.collectionVariable != null) {
            Object obj = execution.getVariable(this.collectionVariable);
            if (!(obj instanceof Collection)) {
                throw LOG.invalidVariableTypeException(this.collectionVariable, "Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else {
            throw LOG.resolveCollectionExpressionOrVariableReferenceException();
        }
        return nrOfInstances;
    }

    protected Object getElementAtIndex(int i, Collection<?> collection) {
        Object value = null;
        Iterator<?> it = collection.iterator();
        for (int index = 0; index <= i; ++index) {
            value = it.next();
        }
        return value;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    protected int resolveLoopCardinality(ActivityExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Integer.parseInt(stringValue);
        }
        throw LOG.expressionNotANumberException("loopCardinality", this.loopCardinalityExpression.getExpressionText());
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw LOG.expressionNotBooleanException("completionCondition", this.completionConditionExpression.getExpressionText());
            }
            Boolean booleanValue = (Boolean)value;
            LOG.multiInstanceCompletionConditionState(booleanValue);
            return booleanValue;
        }
        return false;
    }

    @Override
    public void doLeave(ActivityExecution execution) {
        CompensationUtil.createEventScopeExecution((ExecutionEntity)execution);
        super.doLeave(execution);
    }

    public ActivityImpl getInnerActivity(PvmActivity miBodyActivity) {
        for (PvmActivity pvmActivity : miBodyActivity.getActivities()) {
            ActivityImpl innerActivity = (ActivityImpl)pvmActivity;
            if (innerActivity.isCompensationHandler()) continue;
            return innerActivity;
        }
        throw new ProcessEngineException("inner activity of multi instance body activity '" + miBodyActivity.getId() + "' not found");
    }

    protected void setLoopVariable(ActivityExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ActivityExecution execution, String variableName) {
        IntegerValue value = (IntegerValue)execution.getVariableLocalTyped(variableName);
        EnsureUtil.ensureNotNull("The variable \"" + variableName + "\" could not be found in execution with id " + execution.getId(), "value", (Object)value);
        return (Integer)value.getValue();
    }

    protected Integer getLocalLoopVariable(ActivityExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    public boolean hasLoopVariable(ActivityExecution execution, String variableName) {
        return execution.hasVariableLocal(variableName);
    }

    public void removeLoopVariable(ActivityExecution execution, String variableName) {
        execution.removeVariableLocal(variableName);
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }
}

