/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.delegate.BpmnError;
import io.openbpm.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.delegate.ScriptInvocation;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ExecutableScript script;
    protected String resultVariable;

    public ScriptTaskActivityBehavior(ExecutableScript script, String resultVariable) {
        this.script = script;
        this.resultVariable = resultVariable;
    }

    @Override
    public void performExecution(ActivityExecution execution) throws Exception {
        this.executeWithErrorPropagation(execution, () -> {
            ScriptInvocation invocation = new ScriptInvocation(this.script, execution);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            Object result = invocation.getInvocationResult();
            if (result != null && this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
            this.leave(execution);
            return null;
        });
    }

    protected BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            BpmnError bpmnError = (BpmnError)e;
            return bpmnError;
        }
        if (e.getCause() == null) {
            return null;
        }
        return this.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    public ExecutableScript getScript() {
        return this.script;
    }
}

