/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class SubProcessActivityBehavior
extends AbstractBpmnActivityBehavior
implements CompositeActivityBehavior {
    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity activity = execution.getActivity();
        PvmActivity initialActivity = activity.getProperties().get(BpmnProperties.INITIAL_ACTIVITY);
        EnsureUtil.ensureNotNull("No initial activity found for subprocess " + execution.getActivity().getId(), "initialActivity", (Object)initialActivity);
        execution.executeActivity(initialActivity);
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        endedExecution.remove();
        scopeExecution.tryPruneLastConcurrentChild();
        scopeExecution.forceUpdate();
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
        this.leave(scopeExecution);
    }

    @Override
    public void doLeave(ActivityExecution execution) {
        CompensationUtil.createEventScopeExecution((ExecutionEntity)execution);
        super.doLeave(execution);
    }
}

