/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.listener;

import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.delegate.JavaDelegate;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.delegate.ExecutionListenerInvocation;
import io.openbpm.bpm.engine.impl.bpmn.delegate.JavaDelegateInvocation;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;

public class DelegateExpressionExecutionListener
implements ExecutionListener {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        Object delegate = this.expression.getValue(execution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof ExecutionListener) {
            ExecutionListener executionListener = (ExecutionListener)delegate;
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListener, execution));
        } else if (delegate instanceof JavaDelegate) {
            JavaDelegate javaDelegate = (JavaDelegate)delegate;
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation(javaDelegate, execution));
        } else {
            throw LOG.resolveDelegateExpressionException(this.expression, ExecutionListener.class, JavaDelegate.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

