/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.calendar;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.calendar.BusinessCalendar;
import io.openbpm.bpm.engine.impl.calendar.DateTimeUtil;
import io.openbpm.bpm.engine.impl.util.EngineUtilLogger;
import io.openbpm.bpm.engine.task.Task;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;

public class DueDateBusinessCalendar
implements BusinessCalendar {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static final String NAME = "dueDate";

    @Override
    public Date resolveDuedate(String duedate, Task task) {
        return this.resolveDuedate(duedate);
    }

    @Override
    public Date resolveDuedate(String duedate) {
        return this.resolveDuedate(duedate, (Date)null);
    }

    @Override
    public Date resolveDuedate(String duedate, Date startDate) {
        try {
            if (duedate.startsWith("P")) {
                DateTime start = null;
                start = startDate == null ? DateTimeUtil.now() : new DateTime((Object)startDate);
                return start.plus((ReadablePeriod)ISOPeriodFormat.standard().parsePeriod(duedate)).toDate();
            }
            return DateTimeUtil.parseDateTime(duedate).toDate();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileResolvingDuedate(duedate, e);
        }
    }
}

