/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cfg;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import javax.naming.NamingException;

public class ConfigurationLogger
extends ProcessEngineLogger {
    public ProcessEngineException invalidConfigTransactionManagerIsNull() {
        return new ProcessEngineException(this.exceptionMessage("001", "Property 'transactionManager' is null and 'transactionManagerJndiName' is not set. Please set either the 'transactionManager' property or the 'transactionManagerJndiName' property.", new Object[0]));
    }

    public ProcessEngineException invalidConfigCannotFindTransactionManger(String jndiName, NamingException e) {
        return new ProcessEngineException(this.exceptionMessage("002", "Cannot lookup instance of Jta Transaction manager in JNDI using name '{}'", new Object[]{jndiName}), e);
    }

    public void pluginActivated(String pluginName, String processEngineName) {
        this.logInfo("003", "Plugin '{}' activated on process engine '{}'", new Object[]{pluginName, processEngineName});
    }

    public void debugDatabaseproductName(String databaseProductName) {
        this.logDebug("004", "Database product name {}", new Object[]{databaseProductName});
    }

    public void debugDatabaseType(String databaseType) {
        this.logDebug("005", "Database type {}", new Object[]{databaseType});
    }

    public void usingDeprecatedHistoryLevelVariable() {
        this.logWarn("006", "Using deprecated history level 'variable'. This history level is deprecated and replaced by 'activity'. Consider using 'ACTIVITY' instead.", new Object[0]);
    }

    public ProcessEngineException invalidConfigDefaultUserPermissionNameForTask(String defaultUserPermissionNameForTask, String[] validPermissionNames) {
        return new ProcessEngineException(this.exceptionMessage("007", "Invalid value '{}' for configuration property 'defaultUserPermissionNameForTask'. Valid values are: '{}'", new Object[]{defaultUserPermissionNameForTask, validPermissionNames}));
    }

    public ProcessEngineException invalidPropertyValue(String propertyName, String propertyValue) {
        return new ProcessEngineException(this.exceptionMessage("008", "Invalid value '{}' for configuration property '{}'.", new Object[]{propertyValue, propertyName}));
    }

    public ProcessEngineException invalidPropertyValue(String propertyName, String propertyValue, String reason) {
        return new ProcessEngineException(this.exceptionMessage("009", "Invalid value '{}' for configuration property '{}': {}.", new Object[]{propertyValue, propertyName, reason}));
    }

    public void invalidBatchOperation(String operation, String historyTimeToLive) {
        this.logWarn("010", "Invalid batch operation name '{}' with history time to live set to'{}'", new Object[]{operation, historyTimeToLive});
    }

    public ProcessEngineException invalidPropertyValue(String propertyName, String propertyValue, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("011", "Invalid value '{}' for configuration property '{}'.", new Object[]{propertyValue, propertyName}), e);
    }

    public ProcessEngineException databaseConnectionAccessException(Exception cause) {
        return new ProcessEngineException(this.exceptionMessage("012", "Exception on accessing the database connection: {}", new Object[]{cause.getMessage()}), cause);
    }

    public void databaseConnectionCloseException(Exception cause) {
        this.logError("013", "Exception on closing the database connection: {}", new Object[]{cause.getMessage()});
    }

    public void invalidBatchTypeForInvocationsPerBatchJob(String batchType) {
        this.logWarn("014", "The configuration property 'invocationsPerJobByBatchType' contains an invalid batch type '{}' which is neither a custom nor a built-in batch type", new Object[]{batchType});
    }

    public void invalidPropertyValue(Exception e) {
        this.logError("015", "Exception while reading configuration property: {}", new Object[]{e.getMessage()});
    }

    public void logModelHTTLLongerThanGlobalConfiguration(String definitionKey) {
        this.logWarn("017", "definitionKey: {}; The specified Time To Live (TTL) in the model is longer than the global TTL configuration. The historic data related to this model will be cleaned up at later point comparing to the other processes.", new Object[]{definitionKey});
    }

    public NotValidException logErrorNoTTLConfigured() {
        return new NotValidException(this.exceptionMessage("018", "History Time To Live (TTL) cannot be null. TTL is necessary for the History Cleanup to work. The following options are possible:\n* Set historyTimeToLive in the model\n* Set a default historyTimeToLive as a global process engine configuration\n* (Not recommended) Deactivate the enforceTTL config to disable this check", new Object[0]));
    }

    public ProcessEngineException invalidTransactionIsolationLevel(String transactionIsolationLevel) {
        return new ProcessEngineException(this.exceptionMessage("019", "The transaction isolation level set for the database is '{}' which differs from the recommended value. Please change the isolation level to 'READ_COMMITTED' or set property 'skipIsolationLevelCheck' to true. Please keep in mind that some levels are known to cause deadlocks and other unexpected behaviours.", new Object[]{transactionIsolationLevel}));
    }

    public void logSkippedIsolationLevelCheck(String transactionIsolationLevel) {
        this.logWarn("020", "The transaction isolation level set for the database is '{}' which differs from the recommended value and property skipIsolationLevelCheck is enabled. Please keep in mind that levels different from 'READ_COMMITTED' are known to cause deadlocks and other unexpected behaviours.", new Object[]{transactionIsolationLevel});
    }
}

