/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cfg;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.AbstractTransactionProcessEngineConfiguration;
import io.openbpm.bpm.engine.impl.cfg.ConfigurationLogger;
import io.openbpm.bpm.engine.impl.cfg.jta.JakartaTransactionContextFactory;
import io.openbpm.bpm.engine.impl.interceptor.CommandInterceptor;
import io.openbpm.bpm.engine.impl.interceptor.JakartaTransactionInterceptor;
import jakarta.transaction.TransactionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JakartaTransactionProcessEngineConfiguration
extends AbstractTransactionProcessEngineConfiguration {
    private static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;
    protected TransactionManager transactionManager;

    @Override
    protected CommandInterceptor createTransactionInterceptor(boolean requiresNew) {
        return new JakartaTransactionInterceptor(this.transactionManager, requiresNew, this);
    }

    @Override
    protected void initTransactionManager() {
        if (this.transactionManager == null) {
            if (this.transactionManagerJndiName == null || this.transactionManagerJndiName.isEmpty()) {
                throw LOG.invalidConfigTransactionManagerIsNull();
            }
            try {
                this.transactionManager = (TransactionManager)new InitialContext().lookup(this.transactionManagerJndiName);
            }
            catch (NamingException e) {
                throw LOG.invalidConfigCannotFindTransactionManger(this.transactionManagerJndiName + "'.", e);
            }
        }
    }

    @Override
    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new JakartaTransactionContextFactory(this.transactionManager);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

