/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetTaskPropertyCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;

public abstract class AbstractAddIdentityLinkCmd
extends AbstractSetTaskPropertyCmd<Integer> {
    protected final String userId;
    protected final String groupId;
    protected final String type;

    protected AbstractAddIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        super(taskId, null, true);
        this.validateParameters(type, userId, groupId);
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    @Override
    protected void executeSetOperation(TaskEntity task, Integer value) {
        if (this.isAssignee(this.type)) {
            task.setAssignee(this.userId);
            return;
        }
        if (this.isOwner(this.type)) {
            task.setOwner(this.userId);
            return;
        }
        task.addIdentityLink(this.userId, this.groupId, this.type);
    }

    @Override
    protected abstract void logOperation(CommandContext var1, TaskEntity var2);

    @Override
    protected String getUserOperationLogName() {
        return null;
    }

    protected void validateParameters(String type, String userId, String groupId) {
        if (this.isAssignee(type) && groupId != null) {
            throw new BadUserRequestException("Incompatible usage: cannot use ASSIGNEE together with a groupId");
        }
        if (!this.isAssignee(type) && this.hasNullIdentity(userId, groupId)) {
            throw new NullValueException("userId and groupId cannot both be null");
        }
    }

    protected boolean hasNullIdentity(String userId, String groupId) {
        return userId == null && groupId == null;
    }

    protected boolean isAssignee(String type) {
        return "assignee".equals(type);
    }

    protected boolean isOwner(String type) {
        return "owner".equals(type);
    }
}

