/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractDeleteProcessDefinitionCmd
implements Command<Void>,
Serializable {
    protected boolean cascade;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    protected void deleteProcessDefinitionCmd(CommandContext commandContext, String processDefinitionId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        List<CommandChecker> commandCheckers = commandContext.getProcessEngineConfiguration().getCommandCheckers();
        for (CommandChecker checker : commandCheckers) {
            checker.checkDeleteProcessDefinitionById(processDefinitionId);
        }
        UserOperationLogManager userOperationLogManager = commandContext.getOperationLogManager();
        userOperationLogManager.logProcessDefinitionOperation("Delete", processDefinitionId, processDefinition.getKey(), new PropertyChange("cascade", false, cascade));
        ProcessDefinitionManager definitionManager = commandContext.getProcessDefinitionManager();
        definitionManager.deleteProcessDefinition(processDefinition, processDefinitionId, cascade, cascade, skipCustomListeners, skipIoMappings);
    }
}

