/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.filter.Filter;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.FilterEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.query.Query;
import io.openbpm.bpm.engine.task.TaskQuery;
import java.io.Serializable;

public abstract class AbstractExecuteFilterCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String filterId;
    protected Query<?, ?> extendingQuery;

    protected AbstractExecuteFilterCmd(String filterId) {
        this.filterId = filterId;
    }

    protected AbstractExecuteFilterCmd(String filterId, Query<?, ?> extendingQuery) {
        this.filterId = filterId;
        this.extendingQuery = extendingQuery;
    }

    protected Filter getFilter(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("No filter id given to execute", "filterId", (Object)this.filterId);
        FilterEntity filter = commandContext.getFilterManager().findFilterById(this.filterId);
        EnsureUtil.ensureNotNull("No filter found for id '" + this.filterId + "'", "filter", (Object)filter);
        if (this.extendingQuery != null) {
            ((AbstractQuery)this.extendingQuery).validate();
            filter = (FilterEntity)filter.extend(this.extendingQuery);
        }
        return filter;
    }

    protected Query<?, ?> getFilterQuery(CommandContext commandContext) {
        Filter filter = this.getFilter(commandContext);
        Object query = filter.getQuery();
        if (query instanceof TaskQuery) {
            TaskQuery taskQuery = (TaskQuery)query;
            taskQuery.initializeFormKeys();
        }
        return query;
    }
}

