/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.exception.DeploymentResourceNotFoundException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.form.FormData;
import io.openbpm.bpm.engine.form.OperatonFormRef;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import io.openbpm.bpm.engine.impl.cmd.GetOperatonFormDefinitionCmd;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.repository.OperatonFormDefinition;
import java.io.InputStream;

public abstract class AbstractGetDeployedFormCmd
implements Command<InputStream> {
    protected static final String EMBEDDED_KEY = "embedded:";
    protected static final String OPERATON_FORMS_KEY = "operaton-forms:";
    protected static final String CAMUNDA_FORMS_KEY = "camunda-forms:";
    protected static final int EMBEDDED_KEY_LENGTH = "embedded:".length();
    protected static final int CAMUNDA_FORMS_KEY_LENGTH = "camunda-forms:".length();
    protected static final int OPERATON_FORMS_KEY_LENGTH = "operaton-forms:".length();
    protected static final String DEPLOYMENT_KEY = "deployment:";
    protected static final int DEPLOYMENT_KEY_LENGTH = "deployment:".length();
    protected CommandContext commandContext;

    @Override
    public InputStream execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        this.checkAuthorization();
        FormData formData = this.getFormData();
        String formKey = formData.getFormKey();
        OperatonFormRef operatonFormRef = formData.getOperatonFormRef();
        if (formKey != null) {
            return this.getResourceForFormKey(formData, formKey);
        }
        if (operatonFormRef != null && operatonFormRef.getKey() != null) {
            return this.getResourceForOperatonFormRef(operatonFormRef, formData.getDeploymentId());
        }
        throw new BadUserRequestException("One of the attributes 'formKey' and 'operaton:formRef' must be supplied but none were set.");
    }

    protected InputStream getResourceForFormKey(FormData formData, String formKey) {
        String resourceName = formKey;
        if (resourceName.startsWith(EMBEDDED_KEY)) {
            resourceName = resourceName.substring(EMBEDDED_KEY_LENGTH, resourceName.length());
        } else if (resourceName.startsWith(OPERATON_FORMS_KEY)) {
            resourceName = resourceName.substring(OPERATON_FORMS_KEY_LENGTH, resourceName.length());
        } else if (resourceName.startsWith(CAMUNDA_FORMS_KEY)) {
            resourceName = resourceName.substring(CAMUNDA_FORMS_KEY_LENGTH, resourceName.length());
        }
        if (!resourceName.startsWith(DEPLOYMENT_KEY)) {
            throw new BadUserRequestException("The form key '" + formKey + "' does not reference a deployed form.");
        }
        resourceName = resourceName.substring(DEPLOYMENT_KEY_LENGTH, resourceName.length());
        return this.getDeploymentResource(formData.getDeploymentId(), resourceName);
    }

    protected InputStream getResourceForOperatonFormRef(OperatonFormRef operatonFormRef, String deploymentId) {
        OperatonFormDefinition definition = this.commandContext.runWithoutAuthorization(new GetOperatonFormDefinitionCmd(operatonFormRef, deploymentId));
        if (definition == null) {
            throw new NotFoundException("No OpenBPM Engine Form Definition was found for OpenBPM Engine Form Ref: " + operatonFormRef);
        }
        return this.getDeploymentResource(definition.getDeploymentId(), definition.getResourceName());
    }

    protected InputStream getDeploymentResource(String deploymentId, String resourceName) {
        GetDeploymentResourceCmd getDeploymentResourceCmd = new GetDeploymentResourceCmd(deploymentId, resourceName);
        try {
            return this.commandContext.runWithoutAuthorization(getDeploymentResourceCmd);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException("The form with the resource name '" + resourceName + "' cannot be found in deployment with id " + deploymentId, e);
        }
    }

    protected abstract FormData getFormData();

    protected abstract void checkAuthorization();
}

