/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.ModificationBuilderImpl;
import io.openbpm.bpm.engine.impl.ProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractModificationCmd<T>
implements Command<T> {
    protected ModificationBuilderImpl builder;

    protected AbstractModificationCmd(ModificationBuilderImpl modificationBuilderImpl) {
        this.builder = modificationBuilderImpl;
    }

    protected Collection<String> collectProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.builder.getProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.builder.getProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.builder.getHistoricProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(historicProcessInstanceQuery.listIds());
        }
        return collectedProcessInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, ProcessDefinition processDefinition, int numInstances, boolean async, String annotation) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        commandContext.getOperationLogManager().logProcessInstanceOperation("ModifyProcessInstance", null, processDefinition.getId(), processDefinition.getKey(), propertyChanges, annotation);
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

