/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.Incident;
import java.util.ArrayList;

public class CreateIncidentCmd
implements Command<Incident> {
    protected String incidentType;
    protected String executionId;
    protected String configuration;
    protected String message;

    public CreateIncidentCmd(String incidentType, String executionId, String configuration, String message) {
        this.incidentType = incidentType;
        this.executionId = executionId;
        this.configuration = configuration;
        this.message = message;
    }

    @Override
    public Incident execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Execution id cannot be null", "executionId", (Object)this.executionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "incidentType", (Object)this.incidentType);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find an execution with executionId '" + this.executionId + "'", "execution", (Object)execution);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Execution must be related to an activity", "activity", (Object)execution.getActivity());
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("incidentType", null, this.incidentType));
        propertyChanges.add(new PropertyChange("configuration", null, this.configuration));
        commandContext.getOperationLogManager().logProcessInstanceOperation("CreateIncident", execution.getProcessInstanceId(), execution.getProcessDefinitionId(), null, propertyChanges);
        return execution.createIncident(this.incidentType, this.configuration, this.message);
    }
}

